/*
 * Decompiled with CFR 0.152.
 */
package com.FiveDollaGobby.WelcomeMessages.managers;

import com.FiveDollaGobby.WelcomeMessages.WelcomePlugin;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class DataManager {
    private final WelcomePlugin plugin;
    private final Map<UUID, PlayerData> playerCache = new ConcurrentHashMap<UUID, PlayerData>();
    private File dataFile;
    private FileConfiguration dataConfig;
    private int totalUniqueJoins = 0;

    public DataManager(WelcomePlugin plugin) {
        this.plugin = plugin;
        this.loadDataFile();
        this.startAutoSave();
    }

    private void loadDataFile() {
        ConfigurationSection playersSection;
        this.dataFile = new File(this.plugin.getDataFolder(), "playerdata.yml");
        if (!this.dataFile.exists()) {
            try {
                this.dataFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create playerdata.yml: " + e.getMessage());
            }
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
        this.totalUniqueJoins = this.dataConfig.getInt("total-unique-joins", 0);
        if (this.dataConfig.contains("players") && (playersSection = this.dataConfig.getConfigurationSection("players")) != null) {
            for (String uuidStr : playersSection.getKeys(false)) {
                try {
                    UUID uuid = UUID.fromString(uuidStr);
                    PlayerData data = new PlayerData();
                    data.joinCount = this.dataConfig.getInt("players." + uuidStr + ".join-count", 0);
                    data.firstJoinTime = this.dataConfig.getLong("players." + uuidStr + ".first-join", 0L);
                    data.lastSeenTime = this.dataConfig.getLong("players." + uuidStr + ".last-seen", 0L);
                    data.messagesDisabled = this.dataConfig.getBoolean("players." + uuidStr + ".messages-disabled", false);
                    data.totalPlaytime = this.dataConfig.getLong("players." + uuidStr + ".total-playtime", 0L);
                    data.sessionStartTime = this.dataConfig.getLong("players." + uuidStr + ".session-start", 0L);
                    this.playerCache.put(uuid, data);
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getLogger().warning("Invalid UUID in playerdata: " + uuidStr);
                }
            }
        }
    }

    private void startAutoSave() {
        int saveInterval = this.plugin.getConfig().getInt("general.save-interval", 10);
        if (saveInterval < 1) {
            saveInterval = 1;
            this.plugin.getLogger().warning("Save interval too low, setting to 1 minute");
        } else if (saveInterval > 1440) {
            saveInterval = 1440;
            this.plugin.getLogger().warning("Save interval too high, setting to 1440 minutes (24 hours)");
        }
        long interval = (long)saveInterval * 20L * 60L;
        if (interval > Integer.MAX_VALUE) {
            interval = Integer.MAX_VALUE;
            this.plugin.getLogger().warning("Save interval would cause overflow, capping at maximum value");
        }
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, this::saveData, (long)((int)interval), (long)((int)interval));
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, this::updateAllPlaytime, 6000L, 6000L);
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, this::performCleanup, 72000L, 72000L);
    }

    private void updateAllPlaytime() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.updatePlaytime(player);
        }
    }

    public synchronized void saveData() {
        HashMap<UUID, PlayerData> dataSnapshot = new HashMap<UUID, PlayerData>(this.playerCache);
        int totalJoinsSnapshot = this.totalUniqueJoins;
        for (Map.Entry entry : dataSnapshot.entrySet()) {
            String path = "players." + ((UUID)entry.getKey()).toString();
            PlayerData data = (PlayerData)entry.getValue();
            this.dataConfig.set(path + ".join-count", (Object)data.joinCount);
            this.dataConfig.set(path + ".first-join", (Object)data.firstJoinTime);
            this.dataConfig.set(path + ".last-seen", (Object)data.lastSeenTime);
            this.dataConfig.set(path + ".messages-disabled", (Object)data.messagesDisabled);
            this.dataConfig.set(path + ".total-playtime", (Object)data.totalPlaytime);
            this.dataConfig.set(path + ".session-start", (Object)data.sessionStartTime);
        }
        this.dataConfig.set("total-unique-joins", (Object)totalJoinsSnapshot);
        try {
            this.dataConfig.save(this.dataFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save playerdata.yml: " + e.getMessage());
        }
    }

    public boolean isFirstJoin(Player player) {
        PlayerData data = this.getPlayerData(player);
        return data.firstJoinTime == 0L;
    }

    public void updatePlayerData(Player player) {
        PlayerData data = this.getPlayerData(player);
        if (data.firstJoinTime == 0L) {
            data.firstJoinTime = System.currentTimeMillis();
            ++this.totalUniqueJoins;
        }
        ++data.joinCount;
        data.lastSeenTime = System.currentTimeMillis();
        data.sessionStartTime = System.currentTimeMillis();
    }

    public void setLastSeen(Player player) {
        PlayerData data = this.getPlayerData(player);
        this.updatePlaytime(player);
        data.lastSeenTime = System.currentTimeMillis();
    }

    public void updatePlaytime(Player player) {
        PlayerData data = this.getPlayerData(player);
        if (data.sessionStartTime > 0L) {
            long sessionTime = System.currentTimeMillis() - data.sessionStartTime;
            data.totalPlaytime += sessionTime;
            data.sessionStartTime = System.currentTimeMillis();
        }
    }

    public long getTotalPlaytime(Player player) {
        PlayerData data = this.getPlayerData(player);
        long currentSessionTime = 0L;
        if (data.sessionStartTime > 0L) {
            currentSessionTime = System.currentTimeMillis() - data.sessionStartTime;
        }
        return (data.totalPlaytime + currentSessionTime) / 3600000L;
    }

    public long getCurrentSessionTime(Player player) {
        PlayerData data = this.getPlayerData(player);
        if (data.sessionStartTime > 0L) {
            return (System.currentTimeMillis() - data.sessionStartTime) / 60000L;
        }
        return 0L;
    }

    public int getJoinCount(Player player) {
        return this.getPlayerData((Player)player).joinCount;
    }

    public int getTotalUniqueJoins() {
        return this.totalUniqueJoins;
    }

    public boolean hasMessagesDisabled(Player player) {
        return this.getPlayerData((Player)player).messagesDisabled;
    }

    public boolean toggleMessages(Player player) {
        PlayerData data = this.getPlayerData(player);
        data.messagesDisabled = !data.messagesDisabled;
        return data.messagesDisabled;
    }

    public void resetPlayerData(String playerName) {
        Player onlinePlayer = Bukkit.getPlayer((String)playerName);
        if (onlinePlayer != null) {
            this.playerCache.remove(onlinePlayer.getUniqueId());
            this.dataConfig.set("players." + onlinePlayer.getUniqueId().toString(), null);
            this.plugin.getMessageManager().getSmartRecognitionManager().resetPlayerData(onlinePlayer);
        } else {
            ConfigurationSection playersSection = this.dataConfig.getConfigurationSection("players");
            if (playersSection != null) {
                for (String uuidStr : playersSection.getKeys(false)) {
                    String storedName = this.dataConfig.getString("players." + uuidStr + ".name");
                    if (!playerName.equalsIgnoreCase(storedName)) continue;
                    try {
                        UUID uuid = UUID.fromString(uuidStr);
                        this.playerCache.remove(uuid);
                        this.dataConfig.set("players." + uuidStr, null);
                        this.plugin.getMessageManager().getSmartRecognitionManager().resetPlayerData(uuid);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        this.plugin.getLogger().warning("Invalid UUID format when resetting player data: " + uuidStr + " - " + e.getMessage());
                    }
                }
            }
        }
        this.saveData();
    }

    public void resetPlaytimeData(Player player) {
        PlayerData data = this.getPlayerData(player);
        data.totalPlaytime = 0L;
        data.sessionStartTime = System.currentTimeMillis();
        this.plugin.getMessageManager().getSmartRecognitionManager().resetPlayerData(player);
    }

    private PlayerData getPlayerData(Player player) {
        if (player == null) {
            return new PlayerData();
        }
        return this.playerCache.computeIfAbsent(player.getUniqueId(), k -> new PlayerData());
    }

    public PlayerData getPlayerDataPublic(Player player) {
        return this.getPlayerData(player);
    }

    public void cleanCache() {
        long maxCacheTime = (long)(this.plugin.getConfig().getInt("performance.cache-time", 5) * 60) * 1000L;
        long currentTime = System.currentTimeMillis();
        this.playerCache.entrySet().removeIf(entry -> {
            Player player = Bukkit.getPlayer((UUID)((UUID)entry.getKey()));
            if (player == null || !player.isOnline()) {
                return currentTime - ((PlayerData)entry.getValue()).lastSeenTime > maxCacheTime;
            }
            return false;
        });
    }

    private void performCleanup() {
        this.cleanCache();
        if (this.plugin.getMessageManager() != null && this.plugin.getMessageManager().getSmartRecognitionManager() != null) {
            this.plugin.getMessageManager().getSmartRecognitionManager().cleanupOldData();
        }
        this.plugin.getLogger().info("Performed data cleanup - removed old entries");
    }

    public static class PlayerData {
        public int joinCount = 0;
        public long firstJoinTime = 0L;
        public long lastSeenTime = 0L;
        public boolean messagesDisabled = false;
        public long totalPlaytime = 0L;
        public long sessionStartTime = 0L;
    }
}

