/*
 * Decompiled with CFR 0.152.
 */
package com.FiveDollaGobby.WelcomeMessages.managers;

import com.FiveDollaGobby.WelcomeMessages.WelcomePlugin;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class SmartRecognitionManager {
    private final WelcomePlugin plugin;
    private final Map<UUID, Long> lastSeenTimes = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, Integer> streakData = new ConcurrentHashMap<UUID, Integer>();
    private final Map<UUID, LocalDateTime> lastLoginDate = new ConcurrentHashMap<UUID, LocalDateTime>();
    private final Map<UUID, Set<String>> reachedMilestones = new ConcurrentHashMap<UUID, Set<String>>();

    public SmartRecognitionManager(WelcomePlugin plugin) {
        this.plugin = plugin;
    }

    public String checkMilestones(Player player, boolean isFirstJoin) {
        if (player == null) {
            return null;
        }
        if (!this.plugin.getConfig().getBoolean("smart-recognition.enabled", true)) {
            return null;
        }
        if (!this.plugin.getConfig().getBoolean("smart-recognition.milestones.enabled", true)) {
            return null;
        }
        int joinCount = this.plugin.getDataManager().getJoinCount(player);
        String joinMilestone = this.checkJoinMilestone(player, joinCount);
        if (joinMilestone != null) {
            return joinMilestone;
        }
        String playtimeMilestone = this.checkPlaytimeMilestone(player);
        if (playtimeMilestone != null) {
            return playtimeMilestone;
        }
        String streakMilestone = this.checkStreakMilestone(player);
        if (streakMilestone != null) {
            return streakMilestone;
        }
        return null;
    }

    private String checkJoinMilestone(Player player, int joinCount) {
        List milestones = this.plugin.getConfig().getIntegerList("smart-recognition.milestones.join-milestones");
        int highestUnnotifiedMilestone = -1;
        Iterator iterator = milestones.iterator();
        while (iterator.hasNext()) {
            int milestone = (Integer)iterator.next();
            if (joinCount < milestone || this.hasReachedMilestone(player, "join", milestone) || milestone <= highestUnnotifiedMilestone) continue;
            highestUnnotifiedMilestone = milestone;
        }
        if (highestUnnotifiedMilestone > 0) {
            this.markMilestoneReached(player, "join", highestUnnotifiedMilestone);
            List messages = this.plugin.getMessagesConfig().getStringList("messages.join.milestones.join-milestones." + highestUnnotifiedMilestone);
            if (messages != null && !messages.isEmpty()) {
                String message = (String)messages.get(ThreadLocalRandom.current().nextInt(messages.size()));
                return message.replace("{player}", player.getName()).replace("{milestone}", String.valueOf(highestUnnotifiedMilestone));
            }
        }
        return null;
    }

    private String checkPlaytimeMilestone(Player player) {
        long playtime = this.plugin.getDataManager().getTotalPlaytime(player);
        List milestones = this.plugin.getConfig().getIntegerList("smart-recognition.milestones.playtime-milestones");
        int highestUnnotifiedMilestone = -1;
        Iterator iterator = milestones.iterator();
        while (iterator.hasNext()) {
            int milestone = (Integer)iterator.next();
            if (playtime < (long)milestone || this.hasReachedMilestone(player, "playtime", milestone) || milestone <= highestUnnotifiedMilestone) continue;
            highestUnnotifiedMilestone = milestone;
        }
        if (highestUnnotifiedMilestone > 0) {
            this.markMilestoneReached(player, "playtime", highestUnnotifiedMilestone);
            List messages = this.plugin.getMessagesConfig().getStringList("messages.join.milestones.playtime-milestones." + highestUnnotifiedMilestone);
            if (messages != null && !messages.isEmpty()) {
                String message = (String)messages.get(ThreadLocalRandom.current().nextInt(messages.size()));
                return message.replace("{player}", player.getName()).replace("{milestone}", String.valueOf(highestUnnotifiedMilestone));
            }
        }
        return null;
    }

    private String checkStreakMilestone(Player player) {
        UUID uuid = player.getUniqueId();
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime lastLogin = this.lastLoginDate.get(uuid);
        int streak = this.streakData.getOrDefault(uuid, 0);
        if (lastLogin != null) {
            long daysBetween = ChronoUnit.DAYS.between(lastLogin.toLocalDate(), now.toLocalDate());
            if (daysBetween == 1L) {
                ++streak;
            } else if (daysBetween > 1L) {
                streak = 1;
            }
        } else {
            streak = 1;
        }
        this.streakData.put(uuid, streak);
        this.lastLoginDate.put(uuid, now);
        List milestones = this.plugin.getConfig().getIntegerList("smart-recognition.milestones.streak-milestones");
        int highestUnnotifiedMilestone = -1;
        Iterator iterator = milestones.iterator();
        while (iterator.hasNext()) {
            int milestone = (Integer)iterator.next();
            if (streak < milestone || this.hasReachedMilestone(player, "streak", milestone) || milestone <= highestUnnotifiedMilestone) continue;
            highestUnnotifiedMilestone = milestone;
        }
        if (highestUnnotifiedMilestone > 0) {
            this.markMilestoneReached(player, "streak", highestUnnotifiedMilestone);
            List messages = this.plugin.getMessagesConfig().getStringList("messages.join.milestones.streak-milestones." + highestUnnotifiedMilestone);
            if (messages != null && !messages.isEmpty()) {
                String message = (String)messages.get(ThreadLocalRandom.current().nextInt(messages.size()));
                return message.replace("{player}", player.getName()).replace("{milestone}", String.valueOf(highestUnnotifiedMilestone));
            }
        }
        return null;
    }

    public String getReturningPlayerMessage(Player player) {
        if (player == null) {
            return null;
        }
        if (!this.plugin.getConfig().getBoolean("smart-recognition.enabled", true)) {
            return null;
        }
        if (!this.plugin.getConfig().getBoolean("smart-recognition.returning-player.enabled", true)) {
            return null;
        }
        UUID uuid = player.getUniqueId();
        long lastSeen = this.lastSeenTimes.getOrDefault(uuid, 0L);
        long currentTime = System.currentTimeMillis();
        if (lastSeen == 0L) {
            this.lastSeenTimes.put(uuid, currentTime);
            return null;
        }
        long hoursAbsent = (currentTime - lastSeen) / 3600000L;
        this.lastSeenTimes.put(uuid, currentTime);
        String absenceType = this.getAbsenceType(hoursAbsent);
        if (absenceType == null) {
            return null;
        }
        List messages = this.plugin.getMessagesConfig().getStringList("messages.join.returning." + absenceType);
        if (messages == null || messages.isEmpty()) {
            return null;
        }
        String message = (String)messages.get(ThreadLocalRandom.current().nextInt(messages.size()));
        return message.replace("{player}", player.getName()).replace("{hours}", String.valueOf(hoursAbsent));
    }

    private String getAbsenceType(long hoursAbsent) {
        int shortThreshold = this.plugin.getConfig().getInt("smart-recognition.returning-player.thresholds.short-absence", 24);
        int mediumThreshold = this.plugin.getConfig().getInt("smart-recognition.returning-player.thresholds.medium-absence", 168);
        int longThreshold = this.plugin.getConfig().getInt("smart-recognition.returning-player.thresholds.long-absence", 720);
        int veryLongThreshold = this.plugin.getConfig().getInt("smart-recognition.returning-player.thresholds.very-long-absence", 2160);
        if (hoursAbsent >= (long)veryLongThreshold) {
            return "very-long-absence";
        }
        if (hoursAbsent >= (long)longThreshold) {
            return "long-absence";
        }
        if (hoursAbsent >= (long)mediumThreshold) {
            return "medium-absence";
        }
        if (hoursAbsent >= (long)shortThreshold) {
            return "short-absence";
        }
        return null;
    }

    public Map<String, Object> getPlayerBehavior(Player player) {
        HashMap<String, Object> behavior = new HashMap<String, Object>();
        if (player == null) {
            return behavior;
        }
        if (!this.plugin.getConfig().getBoolean("smart-recognition.behavior.enabled", true)) {
            return behavior;
        }
        if (this.plugin.getConfig().getBoolean("smart-recognition.behavior.peak-activity", true)) {
            behavior.put("peak_activity", this.isPeakActivityTime());
        }
        if (this.plugin.getConfig().getBoolean("smart-recognition.behavior.favorite-world", true)) {
            World world = player.getWorld();
            behavior.put("favorite_world", world != null ? world.getName() : "unknown");
        }
        if (this.plugin.getConfig().getBoolean("smart-recognition.behavior.join-patterns", true)) {
            behavior.put("join_count", this.plugin.getDataManager().getJoinCount(player));
            behavior.put("first_join", this.plugin.getDataManager().isFirstJoin(player));
        }
        return behavior;
    }

    private boolean isPeakActivityTime() {
        int hour = LocalDateTime.now().getHour();
        return hour >= 18 && hour <= 22;
    }

    public String getMilestoneInfo(Player player) {
        if (player == null) {
            return null;
        }
        UUID uuid = player.getUniqueId();
        int joinCount = this.plugin.getDataManager().getJoinCount(player);
        int streak = this.streakData.getOrDefault(uuid, 0);
        long playtime = this.plugin.getDataManager().getTotalPlaytime(player);
        long sessionTime = this.plugin.getDataManager().getCurrentSessionTime(player);
        return String.format("Join Count: %d | Streak: %d days | Total Playtime: %d hours | Current Session: %d minutes", joinCount, streak, playtime, sessionTime);
    }

    private boolean hasReachedMilestone(Player player, String type, int milestone) {
        UUID uuid = player.getUniqueId();
        Set milestones = this.reachedMilestones.computeIfAbsent(uuid, k -> ConcurrentHashMap.newKeySet());
        return milestones.contains(type + ":" + milestone);
    }

    private void markMilestoneReached(Player player, String type, int milestone) {
        UUID uuid = player.getUniqueId();
        Set milestones = this.reachedMilestones.computeIfAbsent(uuid, k -> ConcurrentHashMap.newKeySet());
        milestones.add(type + ":" + milestone);
    }

    public void resetPlayerData(Player player) {
        UUID uuid = player.getUniqueId();
        this.lastSeenTimes.remove(uuid);
        this.streakData.remove(uuid);
        this.lastLoginDate.remove(uuid);
        this.reachedMilestones.remove(uuid);
        this.plugin.getDataManager().resetPlaytimeData(player);
    }

    public void resetPlayerData(UUID uuid) {
        this.lastSeenTimes.remove(uuid);
        this.streakData.remove(uuid);
        this.lastLoginDate.remove(uuid);
        this.reachedMilestones.remove(uuid);
    }

    public void cleanupOldData() {
        long maxAge = 2592000000L;
        long currentTime = System.currentTimeMillis();
        this.reachedMilestones.entrySet().removeIf(entry -> {
            UUID uuid = (UUID)entry.getKey();
            Long lastSeen = this.lastSeenTimes.get(uuid);
            if (lastSeen != null && currentTime - lastSeen > maxAge) {
                this.lastSeenTimes.remove(uuid);
                this.streakData.remove(uuid);
                this.lastLoginDate.remove(uuid);
                return true;
            }
            return false;
        });
        this.streakData.entrySet().removeIf(entry -> {
            UUID uuid = (UUID)entry.getKey();
            Long lastSeen = this.lastSeenTimes.get(uuid);
            return lastSeen != null && currentTime - lastSeen > maxAge;
        });
        this.lastSeenTimes.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > maxAge);
        this.lastLoginDate.entrySet().removeIf(entry -> {
            LocalDateTime loginDate = (LocalDateTime)entry.getValue();
            return loginDate != null && ChronoUnit.DAYS.between(loginDate, LocalDateTime.now()) > 30L;
        });
    }
}

