/*
 * Decompiled with CFR 0.152.
 */
package com.FiveDollaGobby.WelcomeMessages.utils;

import com.FiveDollaGobby.WelcomeMessages.WelcomePlugin;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PerformanceMonitor {
    private final WelcomePlugin plugin;
    private final Map<String, AtomicLong> counters = new ConcurrentHashMap<String, AtomicLong>();
    private final Map<String, AtomicLong> timers = new ConcurrentHashMap<String, AtomicLong>();
    private final Map<String, Long> startTimes = new ConcurrentHashMap<String, Long>();
    private final AtomicLong totalMessages = new AtomicLong(0L);
    private final AtomicLong totalAnimations = new AtomicLong(0L);
    private final AtomicLong totalEffects = new AtomicLong(0L);
    private final AtomicLong totalMilestones = new AtomicLong(0L);
    private final AtomicLong totalThemes = new AtomicLong(0L);
    private final AtomicLong totalPlaceholders = new AtomicLong(0L);
    private final AtomicLong totalMessageTime = new AtomicLong(0L);
    private final AtomicLong totalAnimationTime = new AtomicLong(0L);
    private final AtomicLong totalEffectTime = new AtomicLong(0L);
    private final AtomicLong totalMilestoneTime = new AtomicLong(0L);
    private final AtomicLong totalThemeTime = new AtomicLong(0L);
    private final AtomicLong totalPlaceholderTime = new AtomicLong(0L);
    private final AtomicLong peakMemoryUsage = new AtomicLong(0L);
    private final AtomicLong totalMemoryAllocated = new AtomicLong(0L);
    private final AtomicLong totalErrors = new AtomicLong(0L);
    private final AtomicLong totalWarnings = new AtomicLong(0L);
    private static final long MESSAGE_TIME_THRESHOLD = 50L;
    private static final long ANIMATION_TIME_THRESHOLD = 100L;
    private static final long EFFECT_TIME_THRESHOLD = 200L;
    private static final long MILESTONE_TIME_THRESHOLD = 30L;
    private static final long THEME_TIME_THRESHOLD = 20L;
    private static final long PLACEHOLDER_TIME_THRESHOLD = 10L;

    public PerformanceMonitor(WelcomePlugin plugin) {
        this.plugin = plugin;
        this.startMonitoring();
    }

    private void startMonitoring() {
        new BukkitRunnable(){

            public void run() {
                PerformanceMonitor.this.updateMemoryMetrics();
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 6000L, 6000L);
        new BukkitRunnable(){

            public void run() {
                PerformanceMonitor.this.logPerformanceReport();
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 72000L, 72000L);
    }

    public void startTimer(String operation) {
        this.startTimes.put(operation, System.nanoTime());
    }

    public void endTimer(String operation) {
        Long startTime = this.startTimes.remove(operation);
        if (startTime != null) {
            long duration = System.nanoTime() - startTime;
            long durationMs = TimeUnit.NANOSECONDS.toMillis(duration);
            this.timers.computeIfAbsent(operation, k -> new AtomicLong(0L)).addAndGet(durationMs);
            this.checkPerformanceThreshold(operation, durationMs);
        }
    }

    public void incrementCounter(String counter) {
        this.counters.computeIfAbsent(counter, k -> new AtomicLong(0L)).incrementAndGet();
    }

    public void recordMessage(long durationMs) {
        this.totalMessages.incrementAndGet();
        this.totalMessageTime.addAndGet(durationMs);
        if (durationMs > 50L) {
            this.plugin.getLogger().warning("Slow message processing detected: " + durationMs + "ms");
        }
    }

    public void recordAnimation(long durationMs) {
        this.totalAnimations.incrementAndGet();
        this.totalAnimationTime.addAndGet(durationMs);
        if (durationMs > 100L) {
            this.plugin.getLogger().warning("Slow animation detected: " + durationMs + "ms");
        }
    }

    public void recordEffect(long durationMs) {
        this.totalEffects.incrementAndGet();
        this.totalEffectTime.addAndGet(durationMs);
        if (durationMs > 200L) {
            this.plugin.getLogger().warning("Slow effect processing detected: " + durationMs + "ms");
        }
    }

    public void recordMilestone(long durationMs) {
        this.totalMilestones.incrementAndGet();
        this.totalMilestoneTime.addAndGet(durationMs);
        if (durationMs > 30L) {
            this.plugin.getLogger().warning("Slow milestone processing detected: " + durationMs + "ms");
        }
    }

    public void recordTheme(long durationMs) {
        this.totalThemes.incrementAndGet();
        this.totalThemeTime.addAndGet(durationMs);
        if (durationMs > 20L) {
            this.plugin.getLogger().warning("Slow theme processing detected: " + durationMs + "ms");
        }
    }

    public void recordPlaceholder(long durationMs) {
        this.totalPlaceholders.incrementAndGet();
        this.totalPlaceholderTime.addAndGet(durationMs);
        if (durationMs > 10L) {
            this.plugin.getLogger().warning("Slow placeholder processing detected: " + durationMs + "ms");
        }
    }

    public void recordError() {
        this.totalErrors.incrementAndGet();
    }

    public void recordWarning() {
        this.totalWarnings.incrementAndGet();
    }

    private void checkPerformanceThreshold(String operation, long durationMs) {
        long threshold = this.getThresholdForOperation(operation);
        if (durationMs > threshold) {
            this.plugin.getLogger().warning("Slow " + operation + " detected: " + durationMs + "ms (threshold: " + threshold + "ms)");
        }
    }

    private long getThresholdForOperation(String operation) {
        switch (operation.toLowerCase()) {
            case "message": {
                return 50L;
            }
            case "animation": {
                return 100L;
            }
            case "effect": {
                return 200L;
            }
            case "milestone": {
                return 30L;
            }
            case "theme": {
                return 20L;
            }
            case "placeholder": {
                return 10L;
            }
        }
        return 100L;
    }

    private void updateMemoryMetrics() {
        Runtime runtime = Runtime.getRuntime();
        long usedMemory = runtime.totalMemory() - runtime.freeMemory();
        long maxMemory = runtime.maxMemory();
        long currentPeak = this.peakMemoryUsage.get();
        if (usedMemory > currentPeak) {
            this.peakMemoryUsage.set(usedMemory);
        }
        this.totalMemoryAllocated.addAndGet(usedMemory);
        double memoryUsagePercent = (double)usedMemory / (double)maxMemory * 100.0;
        if (memoryUsagePercent > 80.0) {
            this.plugin.getLogger().warning("High memory usage detected: " + String.format("%.2f", memoryUsagePercent) + "%");
        }
    }

    private void logPerformanceReport() {
        if (!this.plugin.getConfig().getBoolean("performance.monitoring.enabled", true)) {
            return;
        }
        this.plugin.getLogger().info("=== Performance Report ===");
        this.plugin.getLogger().info("Messages processed: " + this.totalMessages.get());
        this.plugin.getLogger().info("Animations executed: " + this.totalAnimations.get());
        this.plugin.getLogger().info("Effects triggered: " + this.totalEffects.get());
        this.plugin.getLogger().info("Milestones detected: " + this.totalMilestones.get());
        this.plugin.getLogger().info("Themes applied: " + this.totalThemes.get());
        this.plugin.getLogger().info("Placeholders resolved: " + this.totalPlaceholders.get());
        this.plugin.getLogger().info("Errors encountered: " + this.totalErrors.get());
        this.plugin.getLogger().info("Warnings generated: " + this.totalWarnings.get());
        if (this.totalMessages.get() > 0L) {
            this.plugin.getLogger().info("Average message time: " + this.totalMessageTime.get() / this.totalMessages.get() + "ms");
        }
        if (this.totalAnimations.get() > 0L) {
            this.plugin.getLogger().info("Average animation time: " + this.totalAnimationTime.get() / this.totalAnimations.get() + "ms");
        }
        if (this.totalEffects.get() > 0L) {
            this.plugin.getLogger().info("Average effect time: " + this.totalEffectTime.get() / this.totalEffects.get() + "ms");
        }
        if (this.totalMilestones.get() > 0L) {
            this.plugin.getLogger().info("Average milestone time: " + this.totalMilestoneTime.get() / this.totalMilestones.get() + "ms");
        }
        if (this.totalThemes.get() > 0L) {
            this.plugin.getLogger().info("Average theme time: " + this.totalThemeTime.get() / this.totalThemes.get() + "ms");
        }
        if (this.totalPlaceholders.get() > 0L) {
            this.plugin.getLogger().info("Average placeholder time: " + this.totalPlaceholderTime.get() / this.totalPlaceholders.get() + "ms");
        }
        Runtime runtime = Runtime.getRuntime();
        long usedMemory = runtime.totalMemory() - runtime.freeMemory();
        long maxMemory = runtime.maxMemory();
        this.plugin.getLogger().info("Current memory usage: " + this.formatBytes(usedMemory) + " / " + this.formatBytes(maxMemory));
        this.plugin.getLogger().info("Peak memory usage: " + this.formatBytes(this.peakMemoryUsage.get()));
        for (Map.Entry<String, AtomicLong> entry : this.counters.entrySet()) {
            this.plugin.getLogger().info(entry.getKey() + ": " + entry.getValue().get());
        }
        this.plugin.getLogger().info("========================");
    }

    public Map<String, Object> getPerformanceStats() {
        ConcurrentHashMap<String, Object> stats = new ConcurrentHashMap<String, Object>();
        stats.put("totalMessages", this.totalMessages.get());
        stats.put("totalAnimations", this.totalAnimations.get());
        stats.put("totalEffects", this.totalEffects.get());
        stats.put("totalMilestones", this.totalMilestones.get());
        stats.put("totalThemes", this.totalThemes.get());
        stats.put("totalPlaceholders", this.totalPlaceholders.get());
        stats.put("totalErrors", this.totalErrors.get());
        stats.put("totalWarnings", this.totalWarnings.get());
        if (this.totalMessages.get() > 0L) {
            stats.put("avgMessageTime", this.totalMessageTime.get() / this.totalMessages.get());
        }
        if (this.totalAnimations.get() > 0L) {
            stats.put("avgAnimationTime", this.totalAnimationTime.get() / this.totalAnimations.get());
        }
        if (this.totalEffects.get() > 0L) {
            stats.put("avgEffectTime", this.totalEffectTime.get() / this.totalEffects.get());
        }
        if (this.totalMilestones.get() > 0L) {
            stats.put("avgMilestoneTime", this.totalMilestoneTime.get() / this.totalMilestones.get());
        }
        if (this.totalThemes.get() > 0L) {
            stats.put("avgThemeTime", this.totalThemeTime.get() / this.totalThemes.get());
        }
        if (this.totalPlaceholders.get() > 0L) {
            stats.put("avgPlaceholderTime", this.totalPlaceholderTime.get() / this.totalPlaceholders.get());
        }
        Runtime runtime = Runtime.getRuntime();
        long usedMemory = runtime.totalMemory() - runtime.freeMemory();
        long maxMemory = runtime.maxMemory();
        stats.put("currentMemoryUsage", usedMemory);
        stats.put("maxMemory", maxMemory);
        stats.put("peakMemoryUsage", this.peakMemoryUsage.get());
        stats.put("memoryUsagePercent", (double)usedMemory / (double)maxMemory * 100.0);
        for (Map.Entry<String, AtomicLong> entry : this.counters.entrySet()) {
            stats.put(entry.getKey(), entry.getValue().get());
        }
        return stats;
    }

    public void resetMetrics() {
        this.totalMessages.set(0L);
        this.totalAnimations.set(0L);
        this.totalEffects.set(0L);
        this.totalMilestones.set(0L);
        this.totalThemes.set(0L);
        this.totalPlaceholders.set(0L);
        this.totalMessageTime.set(0L);
        this.totalAnimationTime.set(0L);
        this.totalEffectTime.set(0L);
        this.totalMilestoneTime.set(0L);
        this.totalThemeTime.set(0L);
        this.totalPlaceholderTime.set(0L);
        this.totalErrors.set(0L);
        this.totalWarnings.set(0L);
        this.peakMemoryUsage.set(0L);
        this.totalMemoryAllocated.set(0L);
        this.counters.clear();
        this.timers.clear();
        this.startTimes.clear();
    }

    private String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(1024.0));
        String pre = "" + "KMGTPE".charAt(exp - 1);
        return String.format("%.1f %sB", (double)bytes / Math.pow(1024.0, exp), pre);
    }

    public String getPerformanceSummary() {
        StringBuilder summary = new StringBuilder();
        summary.append("&6&l=== Performance Summary ===\n");
        summary.append("&7Messages: &e").append(this.totalMessages.get()).append("\n");
        summary.append("&7Animations: &e").append(this.totalAnimations.get()).append("\n");
        summary.append("&7Effects: &e").append(this.totalEffects.get()).append("\n");
        summary.append("&7Milestones: &e").append(this.totalMilestones.get()).append("\n");
        summary.append("&7Themes: &e").append(this.totalThemes.get()).append("\n");
        summary.append("&7Placeholders: &e").append(this.totalPlaceholders.get()).append("\n");
        summary.append("&7Errors: &c").append(this.totalErrors.get()).append("\n");
        summary.append("&7Warnings: &e").append(this.totalWarnings.get()).append("\n");
        Runtime runtime = Runtime.getRuntime();
        long usedMemory = runtime.totalMemory() - runtime.freeMemory();
        long maxMemory = runtime.maxMemory();
        double memoryPercent = (double)usedMemory / (double)maxMemory * 100.0;
        summary.append("&7Memory: &e").append(String.format("%.1f", memoryPercent)).append("%\n");
        summary.append("&6&l========================");
        return summary.toString();
    }
}

