/*
 * Decompiled with CFR 0.152.
 */
package com.FiveDollaGobby.WelcomeMessages.utils;

import java.util.regex.Pattern;

public class SecurityUtils {
    private static final Pattern VALID_PLAYER_NAME = Pattern.compile("^[a-zA-Z0-9_-]{1,16}$");
    private static final Pattern VALID_HEX_COLOR = Pattern.compile("^#[0-9A-Fa-f]{6}$");
    private static final Pattern VALID_THEME_NAME = Pattern.compile("^[a-zA-Z0-9_-]+$");
    private static final Pattern VALID_ANIMATION_TYPE = Pattern.compile("^[a-zA-Z0-9_-]+$");

    public static String sanitizePlayerName(String input) {
        if (input == null || input.trim().isEmpty()) {
            return null;
        }
        String sanitized = input.trim();
        if (!VALID_PLAYER_NAME.matcher(sanitized).matches()) {
            return null;
        }
        return sanitized;
    }

    public static String sanitizeText(String input) {
        if (input == null) {
            return "";
        }
        Object sanitized = input.replaceAll("[\\p{Cntrl}&&[^\r\n\t]]", "").trim();
        if (((String)sanitized).length() > 1000) {
            sanitized = ((String)sanitized).substring(0, 997) + "...";
        }
        return sanitized;
    }

    public static String sanitizeThemeName(String input) {
        if (input == null || input.trim().isEmpty()) {
            return null;
        }
        String sanitized = input.trim().toLowerCase();
        if (!VALID_THEME_NAME.matcher(sanitized).matches()) {
            return null;
        }
        return sanitized;
    }

    public static String sanitizeAnimationType(String input) {
        if (input == null || input.trim().isEmpty()) {
            return null;
        }
        String sanitized = input.trim().toLowerCase();
        if (!VALID_ANIMATION_TYPE.matcher(sanitized).matches()) {
            return null;
        }
        return sanitized;
    }

    public static boolean isValidHexColor(String input) {
        if (input == null) {
            return false;
        }
        return VALID_HEX_COLOR.matcher(input).matches();
    }

    public static String escapeHtml(String input) {
        if (input == null) {
            return "";
        }
        return input.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#x27;");
    }

    public static boolean isSafeForDisplay(String input) {
        String[] dangerousPatterns;
        if (input == null) {
            return true;
        }
        String lower = input.toLowerCase();
        for (String pattern : dangerousPatterns = new String[]{"<script", "javascript:", "data:", "vbscript:", "onload=", "onerror=", "onclick=", "onmouseover="}) {
            if (!lower.contains(pattern)) continue;
            return false;
        }
        return true;
    }
}

