/*
 * Decompiled with CFR 0.152.
 */
package com.FiveDollaGobby.WelcomeMessages;

import com.FiveDollaGobby.WelcomeMessages.WelcomePlugin;
import java.util.concurrent.Callable;
import org.bukkit.plugin.java.JavaPlugin;

public class Metrics {
    private final WelcomePlugin plugin;
    private final int pluginId;
    private Object bStatsMetrics;

    public Metrics(WelcomePlugin plugin, int pluginId) {
        this.plugin = plugin;
        this.pluginId = pluginId;
        this.initializeBStats();
    }

    private void initializeBStats() {
        try {
            Class<?> metricsClass = Class.forName("org.bstats.bukkit.Metrics");
            this.bStatsMetrics = metricsClass.getConstructor(JavaPlugin.class, Integer.TYPE).newInstance(new Object[]{this.plugin, this.pluginId});
            this.addCustomCharts();
            this.plugin.getLogger().info("bStats metrics enabled successfully!");
        }
        catch (Exception e) {
            this.plugin.getLogger().info("bStats metrics not available - metrics disabled");
        }
    }

    private void addCustomCharts() {
        if (this.bStatsMetrics == null) {
            return;
        }
        try {
            this.addSimplePieChart("storage_type", () -> this.plugin.getConfig().getString("storage.type", "yaml"));
            this.addSimplePieChart("join_messages_enabled", () -> this.plugin.getConfig().getBoolean("messages.join.enabled", true) ? "Enabled" : "Disabled");
            this.addSimplePieChart("quit_messages_enabled", () -> this.plugin.getConfig().getBoolean("messages.quit.enabled", true) ? "Enabled" : "Disabled");
            this.addSimplePieChart("effects_usage", () -> {
                boolean title = this.plugin.getConfig().getBoolean("effects.title.enabled", true);
                boolean sound = this.plugin.getConfig().getBoolean("effects.sound.enabled", true);
                boolean particles = this.plugin.getConfig().getBoolean("effects.particles.enabled", true);
                boolean fireworks = this.plugin.getConfig().getBoolean("effects.fireworks.enabled", true);
                if (title && sound && particles && fireworks) {
                    return "All Effects";
                }
                if (!(title || sound || particles || fireworks)) {
                    return "No Effects";
                }
                return "Some Effects";
            });
            this.addSingleLineChart("unique_players", () -> this.plugin.getDataManager().getTotalUniqueJoins());
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to add custom bStats charts: " + e.getMessage());
        }
    }

    private void addSimplePieChart(String chartId, Callable<String> callable) {
        try {
            Class<?> simplePieClass = Class.forName("org.bstats.charts.SimplePie");
            Object chart = simplePieClass.getConstructor(String.class, Callable.class).newInstance(chartId, callable);
            this.bStatsMetrics.getClass().getMethod("addCustomChart", Class.forName("org.bstats.charts.CustomChart")).invoke(this.bStatsMetrics, chart);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addSingleLineChart(String chartId, Callable<Integer> callable) {
        try {
            Class<?> singleLineClass = Class.forName("org.bstats.charts.SingleLineChart");
            Object chart = singleLineClass.getConstructor(String.class, Callable.class).newInstance(chartId, callable);
            this.bStatsMetrics.getClass().getMethod("addCustomChart", Class.forName("org.bstats.charts.CustomChart")).invoke(this.bStatsMetrics, chart);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

