/*
 * Decompiled with CFR 0.152.
 */
package com.FiveDollaGobby.WelcomeMessages;

import com.FiveDollaGobby.WelcomeMessages.Metrics;
import com.FiveDollaGobby.WelcomeMessages.commands.WelcomeCommand;
import com.FiveDollaGobby.WelcomeMessages.listeners.PlayerJoinListener;
import com.FiveDollaGobby.WelcomeMessages.managers.DataManager;
import com.FiveDollaGobby.WelcomeMessages.managers.EffectManager;
import com.FiveDollaGobby.WelcomeMessages.managers.MessageManager;
import com.FiveDollaGobby.WelcomeMessages.placeholders.WelcomePlaceholders;
import com.FiveDollaGobby.WelcomeMessages.utils.ConfigValidator;
import com.FiveDollaGobby.WelcomeMessages.utils.MessageUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.logging.Level;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class WelcomePlugin
extends JavaPlugin {
    private static WelcomePlugin instance;
    private MessageManager messageManager;
    private EffectManager effectManager;
    private DataManager dataManager;
    private FileConfiguration messagesConfig;
    private File messagesFile;

    public void onEnable() {
        instance = this;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        this.saveDefaultConfig();
        this.loadMessagesConfig();
        ConfigValidator validator = new ConfigValidator(this);
        if (!validator.validateConfig()) {
            MessageUtils.sendConsole("&cPlugin disabled due to configuration errors!");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.messageManager = new MessageManager(this);
        this.effectManager = new EffectManager(this);
        this.dataManager = new DataManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinListener(this), (Plugin)this);
        this.getCommand("welcome").setExecutor((CommandExecutor)new WelcomeCommand(this));
        this.getCommand("welcome").setTabCompleter((TabCompleter)new WelcomeCommand(this));
        MessageUtils.sendConsole("&aWelcomeMessages v" + this.getDescription().getVersion() + " has been enabled!");
        if (this.getConfig().getBoolean("metrics.enabled", true)) {
            int pluginId = 20000;
            new Metrics(this, pluginId);
        }
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new WelcomePlaceholders(this).register();
            MessageUtils.sendConsole("&aPlaceholderAPI support enabled!");
        } else {
            MessageUtils.sendConsole("&ePlaceholderAPI not found - placeholders disabled");
        }
    }

    public void onDisable() {
        if (this.dataManager != null) {
            this.dataManager.saveData();
        }
        MessageUtils.sendConsole("&cWelcomeMessages has been disabled!");
    }

    private void loadMessagesConfig() {
        this.messagesFile = new File(this.getDataFolder(), "messages.yml");
        if (!this.messagesFile.exists()) {
            this.saveResource("messages.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        InputStream defConfigStream = this.getResource("messages.yml");
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream));
            this.messagesConfig.setDefaults((Configuration)defConfig);
        }
    }

    public void reloadMessagesConfig() {
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
    }

    public void saveMessagesConfig() {
        try {
            this.messagesConfig.save(this.messagesFile);
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Could not save messages.yml!", e);
        }
    }

    public static WelcomePlugin getInstance() {
        return instance;
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public EffectManager getEffectManager() {
        return this.effectManager;
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public FileConfiguration getMessagesConfig() {
        return this.messagesConfig;
    }

    public void reload() {
        this.reloadConfig();
        this.reloadMessagesConfig();
        ConfigValidator validator = new ConfigValidator(this);
        if (!validator.validateConfig()) {
            MessageUtils.sendConsole("&cReload failed due to configuration errors!");
            return;
        }
        this.messageManager.reload();
        this.effectManager.reload();
        MessageUtils.sendConsole("&aConfiguration reloaded successfully!");
    }
}

