/*
 * Decompiled with CFR 0.152.
 */
package com.FiveDollaGobby.WelcomeMessages.commands;

import com.FiveDollaGobby.WelcomeMessages.WelcomePlugin;
import com.FiveDollaGobby.WelcomeMessages.utils.MessageUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.StringUtil;

public class WelcomeCommand
implements CommandExecutor,
TabCompleter {
    private final WelcomePlugin plugin;
    private final Map<UUID, Long> commandCooldowns = new HashMap<UUID, Long>();

    public WelcomeCommand(WelcomePlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "help": {
                this.sendHelp(sender);
                break;
            }
            case "reload": {
                this.handleReload(sender);
                break;
            }
            case "test": {
                this.handleTest(sender, args);
                break;
            }
            case "testall": {
                this.handleTestAll(sender, args);
                break;
            }
            case "stats": {
                this.handleStats(sender, args);
                break;
            }
            case "reset": {
                this.handleReset(sender, args);
                break;
            }
            case "toggle": {
                this.handleToggle(sender);
                break;
            }
            case "version": {
                this.handleVersion(sender);
                break;
            }
            default: {
                MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.unknown-command"));
            }
        }
        return true;
    }

    private void sendHelp(CommandSender sender) {
        if (!sender.hasPermission("welcome.use")) {
            MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.no-permission"));
            return;
        }
        MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.help.header"));
        List commands = this.plugin.getMessagesConfig().getStringList("commands.help.commands");
        for (String cmd : commands) {
            if (cmd.contains("reload") && !sender.hasPermission("welcome.reload") || cmd.contains("test") && !sender.hasPermission("welcome.test") || cmd.contains("stats") && !sender.hasPermission("welcome.stats") || cmd.contains("reset") && !sender.hasPermission("welcome.reset")) continue;
            MessageUtils.sendMessage(sender, cmd);
        }
        MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.help.footer"));
    }

    private void handleReload(CommandSender sender) {
        if (!sender.hasPermission("welcome.reload")) {
            MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.no-permission"));
            return;
        }
        try {
            this.plugin.reload();
            MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.reload-success"));
        }
        catch (Exception e) {
            MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.reload-error"));
            this.plugin.getLogger().severe("Error reloading configuration: " + e.getMessage());
        }
    }

    private void handleTest(CommandSender sender, String[] args) {
        Player target;
        if (!sender.hasPermission("welcome.test")) {
            MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.no-permission"));
            return;
        }
        if (args.length > 1) {
            target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                String msg = this.plugin.getMessagesConfig().getString("commands.player-not-found");
                MessageUtils.sendMessage(sender, msg.replace("{player}", args[1]));
                return;
            }
        } else if (sender instanceof Player) {
            target = (Player)sender;
        } else {
            MessageUtils.sendMessage(sender, "&cPlease specify a player name!");
            return;
        }
        boolean isFirstJoin = this.plugin.getDataManager().isFirstJoin(target);
        String joinMessage = this.plugin.getMessageManager().getJoinMessage(target, isFirstJoin);
        MessageUtils.sendMessage(sender, "&6Testing join message for &e" + target.getName() + "&6:");
        MessageUtils.sendMessage(sender, joinMessage);
        String quitMessage = this.plugin.getMessageManager().getQuitMessage(target);
        MessageUtils.sendMessage(sender, "&6Quit message:");
        MessageUtils.sendMessage(sender, quitMessage);
        if (sender.equals((Object)target)) {
            MessageUtils.sendMessage(sender, "&6Testing effects in 2 seconds...");
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                this.plugin.getEffectManager().sendTitle(target, isFirstJoin);
                this.plugin.getEffectManager().playJoinSound(target, isFirstJoin);
                this.plugin.getEffectManager().playJoinParticles(target, isFirstJoin);
            }, 40L);
        }
    }

    private void handleTestAll(CommandSender sender, String[] args) {
        Player target;
        if (!sender.hasPermission("welcome.test")) {
            MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.no-permission"));
            return;
        }
        if (args.length > 1) {
            target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                String msg = this.plugin.getMessagesConfig().getString("commands.player-not-found");
                MessageUtils.sendMessage(sender, msg.replace("{player}", args[1]));
                return;
            }
        } else if (sender instanceof Player) {
            target = (Player)sender;
        } else {
            MessageUtils.sendMessage(sender, "&cPlease specify a player name!");
            return;
        }
        MessageUtils.sendMessage(sender, "&6&l=== WelcomeMessages Feature Showcase ===");
        MessageUtils.sendMessage(sender, "&7Testing all features for: &e" + target.getName());
        MessageUtils.sendMessage(sender, "");
        MessageUtils.sendMessage(sender, "&a&l1. Basic Messages:");
        boolean isFirstJoin = this.plugin.getDataManager().isFirstJoin(target);
        String joinMessage = this.plugin.getMessageManager().getJoinMessage(target, isFirstJoin);
        String quitMessage = this.plugin.getMessageManager().getQuitMessage(target);
        MessageUtils.sendMessage(sender, "&7Join: " + joinMessage);
        MessageUtils.sendMessage(sender, "&7Quit: " + quitMessage);
        MessageUtils.sendMessage(sender, "");
        MessageUtils.sendMessage(sender, "&a&l2. RGB & Gradient Text:");
        MessageUtils.sendMessage(sender, "&7Basic RGB: &#FF6B6BHello &#4ECDC4World &#45B7D1Test");
        MessageUtils.sendMessage(sender, "&7Gradient: <gradient:#FF6B6B:#4ECDC4>Welcome to our server!</gradient>");
        MessageUtils.sendMessage(sender, "&7Rainbow: <rainbow>This is rainbow text!</rainbow>");
        MessageUtils.sendMessage(sender, "");
        MessageUtils.sendMessage(sender, "&a&l3. PlaceholderAPI Examples:");
        MessageUtils.sendMessage(sender, "&7Join Count: &e" + this.plugin.getDataManager().getJoinCount(target));
        MessageUtils.sendMessage(sender, "&7First Join: &e" + (isFirstJoin ? "Yes" : "No"));
        MessageUtils.sendMessage(sender, "&7Messages Disabled: &e" + this.plugin.getDataManager().hasMessagesDisabled(target));
        MessageUtils.sendMessage(sender, "&7Player Status: &e" + (isFirstJoin ? "New Player" : "Returning Player"));
        MessageUtils.sendMessage(sender, "");
        MessageUtils.sendMessage(sender, "&a&l4. Rank System:");
        if (this.plugin.getConfig().getBoolean("custom-ranks.enabled", true)) {
            List customRanks = this.plugin.getConfig().getStringList("custom-ranks.ranks");
            if (!customRanks.isEmpty()) {
                MessageUtils.sendMessage(sender, "&7Custom ranks enabled. Checking permissions:");
                boolean foundRank = false;
                for (String rank : customRanks) {
                    if (!target.hasPermission("welcome.rank." + rank)) continue;
                    MessageUtils.sendMessage(sender, "&7You have &e" + rank.toUpperCase() + " &7rank permissions");
                    foundRank = true;
                    break;
                }
                if (!foundRank) {
                    MessageUtils.sendMessage(sender, "&7No custom rank permissions found");
                }
            } else {
                MessageUtils.sendMessage(sender, "&7Custom ranks enabled but no ranks configured");
            }
        } else {
            MessageUtils.sendMessage(sender, "&7Custom ranks disabled, using default system:");
            String[] defaultRanks = new String[]{"owner", "admin", "mvp", "vip"};
            boolean foundRank = false;
            for (String rank : defaultRanks) {
                if (!target.hasPermission("welcome.rank." + rank)) continue;
                MessageUtils.sendMessage(sender, "&7You have &e" + rank.toUpperCase() + " &7rank permissions");
                foundRank = true;
                break;
            }
            if (!foundRank) {
                MessageUtils.sendMessage(sender, "&7No default rank permissions found");
            }
        }
        MessageUtils.sendMessage(sender, "");
        if (sender.equals((Object)target)) {
            MessageUtils.sendMessage(sender, "&a&l5. Visual Effects (starting in 3 seconds):");
            MessageUtils.sendMessage(sender, "&7- Title effects");
            MessageUtils.sendMessage(sender, "&7- Sound effects");
            MessageUtils.sendMessage(sender, "&7- Particle effects");
            MessageUtils.sendMessage(sender, "&7- Firework effects");
            MessageUtils.sendMessage(sender, "");
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                MessageUtils.sendMessage((CommandSender)target, "&6&l>>> Title Effect <<<");
                this.plugin.getEffectManager().sendTitle(target, isFirstJoin);
            }, 60L);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                MessageUtils.sendMessage((CommandSender)target, "&6&l>>> Sound Effect <<<");
                this.plugin.getEffectManager().playJoinSound(target, isFirstJoin);
            }, 80L);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                MessageUtils.sendMessage((CommandSender)target, "&6&l>>> Particle Effect <<<");
                this.plugin.getEffectManager().playJoinParticles(target, isFirstJoin);
            }, 100L);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                MessageUtils.sendMessage((CommandSender)target, "&6&l>>> Firework Effect <<<");
                this.plugin.getEffectManager().launchFireworks(target);
            }, 120L);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                MessageUtils.sendMessage((CommandSender)target, "&6&l=== Showcase Complete! ===");
                MessageUtils.sendMessage((CommandSender)target, "&7All features have been demonstrated.");
                MessageUtils.sendMessage((CommandSender)target, "&7Perfect for screenshots! \ud83d\udcf8");
            }, 140L);
        } else {
            MessageUtils.sendMessage(sender, "&a&l5. Visual Effects:");
            MessageUtils.sendMessage(sender, "&7Effects can only be shown to the target player");
            MessageUtils.sendMessage(sender, "&7Run &e/welcome testall &7on yourself to see effects");
            MessageUtils.sendMessage(sender, "");
            MessageUtils.sendMessage(sender, "&6&l=== Showcase Complete! ===");
        }
    }

    private void handleStats(CommandSender sender, String[] args) {
        Player target;
        if (!sender.hasPermission("welcome.stats")) {
            MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.no-permission"));
            return;
        }
        if (args.length > 1) {
            target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                MessageUtils.sendMessage(sender, "&cPlayer must be online to view stats!");
                return;
            }
        } else if (sender instanceof Player) {
            target = (Player)sender;
        } else {
            MessageUtils.sendMessage(sender, "&cPlease specify a player name!");
            return;
        }
        MessageUtils.sendMessage(sender, "&6&l--- Player Statistics ---");
        MessageUtils.sendMessage(sender, "&ePlayer: &f" + target.getName());
        MessageUtils.sendMessage(sender, "&eJoin Count: &f" + this.plugin.getDataManager().getJoinCount(target));
        MessageUtils.sendMessage(sender, "&eFirst Join: &f" + (this.plugin.getDataManager().isFirstJoin(target) ? "Never" : "Yes"));
        MessageUtils.sendMessage(sender, "&eMessages Enabled: &f" + !this.plugin.getDataManager().hasMessagesDisabled(target));
        MessageUtils.sendMessage(sender, "&6&l----------------------");
    }

    private void handleReset(CommandSender sender, String[] args) {
        if (!sender.hasPermission("welcome.reset")) {
            MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.no-permission"));
            return;
        }
        if (args.length < 2) {
            MessageUtils.sendMessage(sender, "&cUsage: /welcome reset <player>");
            return;
        }
        String playerName = args[1];
        this.plugin.getDataManager().resetPlayerData(playerName);
        MessageUtils.sendMessage(sender, "&aPlayer data reset for &e" + playerName);
    }

    private void handleToggle(CommandSender sender) {
        if (!(sender instanceof Player)) {
            MessageUtils.sendMessage(sender, "&cOnly players can toggle their messages!");
            return;
        }
        if (!sender.hasPermission("welcome.toggle")) {
            MessageUtils.sendMessage(sender, this.plugin.getMessagesConfig().getString("commands.no-permission"));
            return;
        }
        Player player = (Player)sender;
        UUID uuid = player.getUniqueId();
        long lastUse = this.commandCooldowns.getOrDefault(uuid, 0L);
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastUse < 5000L && !player.hasPermission("welcome.effects.bypass")) {
            MessageUtils.sendMessage((CommandSender)player, "&cPlease wait before using this command again!");
            return;
        }
        this.commandCooldowns.put(uuid, currentTime);
        boolean disabled = this.plugin.getDataManager().toggleMessages(player);
        if (disabled) {
            MessageUtils.sendMessage((CommandSender)player, "&cYour join/quit messages have been disabled!");
        } else {
            MessageUtils.sendMessage((CommandSender)player, "&aYour join/quit messages have been enabled!");
        }
    }

    private void handleVersion(CommandSender sender) {
        MessageUtils.sendMessage(sender, "&6WelcomeMessages &ev" + this.plugin.getDescription().getVersion());
        MessageUtils.sendMessage(sender, "&7Created by &eFiveDollaGobby");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        String subCommand;
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            List<String> subCommands = Arrays.asList("help", "reload", "test", "testall", "stats", "reset", "toggle", "version");
            StringUtil.copyPartialMatches((String)args[0], subCommands, completions);
        } else if (args.length == 2 && ((subCommand = args[0].toLowerCase()).equals("test") || subCommand.equals("testall") || subCommand.equals("stats") || subCommand.equals("reset"))) {
            List playerNames = Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
            StringUtil.copyPartialMatches((String)args[1], playerNames, completions);
        }
        Collections.sort(completions);
        return completions;
    }
}

