/*
 * Decompiled with CFR 0.152.
 */
package com.FiveDollaGobby.WelcomeMessages.utils;

import com.FiveDollaGobby.WelcomeMessages.WelcomePlugin;
import com.FiveDollaGobby.WelcomeMessages.utils.MessageUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AnimationUtils {
    private final WelcomePlugin plugin;

    public AnimationUtils(WelcomePlugin plugin) {
        this.plugin = plugin;
    }

    public void animateMessage(Player player, String message, String animationType, int duration) {
        if (message == null || message.isEmpty()) {
            return;
        }
        switch (animationType.toLowerCase()) {
            case "typing": {
                this.animateTyping(player, message, duration);
                break;
            }
            case "fade": {
                this.animateFade(player, message, duration);
                break;
            }
            case "slide": {
                this.animateSlide(player, message, duration);
                break;
            }
            case "wave": {
                this.animateWave(player, message, duration);
                break;
            }
            case "rainbow": {
                this.animateRainbow(player, message, duration);
                break;
            }
            case "glitch": {
                this.animateGlitch(player, message, duration);
                break;
            }
            case "typewriter": {
                this.animateTypewriter(player, message, duration);
                break;
            }
            case "bounce": {
                this.animateBounce(player, message, duration);
                break;
            }
            case "shake": {
                this.animateShake(player, message, duration);
                break;
            }
            case "pulse": {
                this.animatePulse(player, message, duration);
                break;
            }
            case "matrix": {
                this.animateMatrix(player, message, duration);
                break;
            }
            case "scramble": {
                this.animateScramble(player, message, duration);
                break;
            }
            default: {
                this.animateTyping(player, message, duration);
            }
        }
    }

    private void animateTyping(final Player player, final String message, int duration) {
        String cleanMessage = MessageUtils.stripColors(message);
        final int totalChars = cleanMessage.length();
        int delay = Math.max(1, duration / totalChars);
        new BukkitRunnable(){
            int currentChar = 0;

            public void run() {
                if (this.currentChar >= totalChars) {
                    AnimationUtils.this.sendActionBar(player, message);
                    this.cancel();
                    return;
                }
                StringBuilder partialMessage = new StringBuilder();
                int charCount = 0;
                boolean inColorCode = false;
                for (int i = 0; i < message.length() && charCount <= this.currentChar; ++i) {
                    char c = message.charAt(i);
                    if (c == '&' && i + 1 < message.length()) {
                        partialMessage.append(c).append(message.charAt(i + 1));
                        inColorCode = true;
                        ++i;
                        continue;
                    }
                    if (inColorCode) {
                        inColorCode = false;
                        continue;
                    }
                    if (charCount <= this.currentChar) {
                        partialMessage.append(c);
                    }
                    ++charCount;
                }
                AnimationUtils.this.sendActionBar(player, partialMessage.toString());
                ++this.currentChar;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, (long)delay);
    }

    private void animateFade(final Player player, final String message, int duration) {
        final int steps = 10;
        int delay = duration / steps;
        new BukkitRunnable(){
            int currentStep = 0;

            public void run() {
                if (this.currentStep >= steps) {
                    this.cancel();
                    return;
                }
                float opacity = (float)this.currentStep / (float)(steps - 1);
                String animatedMessage = AnimationUtils.this.applyOpacity(message, opacity);
                AnimationUtils.this.sendActionBar(player, animatedMessage);
                ++this.currentStep;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, (long)delay);
    }

    private void animateSlide(final Player player, final String message, int duration) {
        int maxSpaces;
        final int steps = maxSpaces = 20;
        int delay = duration / steps;
        new BukkitRunnable(){
            int currentStep = 0;

            public void run() {
                if (this.currentStep >= steps) {
                    this.cancel();
                    return;
                }
                int spaces = maxSpaces - this.currentStep;
                String spacesStr = " ".repeat(Math.max(0, spaces));
                String animatedMessage = spacesStr + message;
                AnimationUtils.this.sendActionBar(player, animatedMessage);
                ++this.currentStep;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, (long)delay);
    }

    private void animateWave(final Player player, String message, int duration) {
        final String cleanMessage = MessageUtils.stripColors(message);
        final int steps = 20;
        int delay = duration / steps;
        new BukkitRunnable(){
            int currentStep = 0;

            public void run() {
                if (this.currentStep >= steps) {
                    this.cancel();
                    return;
                }
                StringBuilder animatedMessage = new StringBuilder();
                for (int i = 0; i < cleanMessage.length(); ++i) {
                    char c = cleanMessage.charAt(i);
                    if (c == ' ') {
                        animatedMessage.append(' ');
                        continue;
                    }
                    double wave = Math.sin((double)(this.currentStep + i) * 0.5) * 2.0;
                    int spaces = (int)Math.abs(wave);
                    animatedMessage.append(" ".repeat(spaces)).append(c);
                }
                AnimationUtils.this.sendActionBar(player, MessageUtils.colorize(animatedMessage.toString()));
                ++this.currentStep;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, (long)delay);
    }

    private void animateRainbow(final Player player, String message, int duration) {
        final String cleanMessage = MessageUtils.stripColors(message);
        final int steps = 20;
        int delay = duration / steps;
        new BukkitRunnable(){
            int currentStep = 0;

            public void run() {
                if (this.currentStep >= steps) {
                    this.cancel();
                    return;
                }
                StringBuilder animatedMessage = new StringBuilder();
                for (int i = 0; i < cleanMessage.length(); ++i) {
                    char c = cleanMessage.charAt(i);
                    if (c == ' ') {
                        animatedMessage.append(' ');
                        continue;
                    }
                    String color = AnimationUtils.this.getRainbowColor((this.currentStep + i) % 6);
                    animatedMessage.append("&").append(color).append(c);
                }
                AnimationUtils.this.sendActionBar(player, MessageUtils.colorize(animatedMessage.toString()));
                ++this.currentStep;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, (long)delay);
    }

    private void animateGlitch(final Player player, final String message, int duration) {
        final String cleanMessage = MessageUtils.stripColors(message);
        final int steps = 15;
        int delay = duration / steps;
        new BukkitRunnable(){
            int currentStep = 0;

            public void run() {
                if (this.currentStep >= steps) {
                    AnimationUtils.this.sendActionBar(player, message);
                    this.cancel();
                    return;
                }
                StringBuilder animatedMessage = new StringBuilder();
                for (int i = 0; i < cleanMessage.length(); ++i) {
                    char c = cleanMessage.charAt(i);
                    if (c == ' ') {
                        animatedMessage.append(' ');
                        continue;
                    }
                    if (ThreadLocalRandom.current().nextDouble() < 0.3) {
                        char glitchChar = (char)ThreadLocalRandom.current().nextInt(33, 127);
                        animatedMessage.append("&c").append(glitchChar);
                        continue;
                    }
                    animatedMessage.append(c);
                }
                AnimationUtils.this.sendActionBar(player, MessageUtils.colorize(animatedMessage.toString()));
                ++this.currentStep;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, (long)delay);
    }

    private void animateTypewriter(final Player player, final String message, int duration) {
        String cleanMessage = MessageUtils.stripColors(message);
        final int totalChars = cleanMessage.length();
        int delay = Math.max(1, duration / totalChars);
        new BukkitRunnable(){
            int currentChar = 0;
            boolean showCursor = true;

            public void run() {
                if (this.currentChar >= totalChars) {
                    AnimationUtils.this.sendActionBar(player, message);
                    this.cancel();
                    return;
                }
                StringBuilder partialMessage = new StringBuilder();
                int charCount = 0;
                boolean inColorCode = false;
                for (int i = 0; i < message.length() && charCount <= this.currentChar; ++i) {
                    char c = message.charAt(i);
                    if (c == '&' && i + 1 < message.length()) {
                        partialMessage.append(c).append(message.charAt(i + 1));
                        inColorCode = true;
                        ++i;
                        continue;
                    }
                    if (inColorCode) {
                        inColorCode = false;
                        continue;
                    }
                    if (charCount <= this.currentChar) {
                        partialMessage.append(c);
                    }
                    ++charCount;
                }
                if (this.showCursor) {
                    partialMessage.append("&7_");
                } else {
                    partialMessage.append("&8_");
                }
                AnimationUtils.this.sendActionBar(player, partialMessage.toString());
                ++this.currentChar;
                this.showCursor = !this.showCursor;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, (long)delay);
    }

    private void animateBounce(final Player player, final String message, int duration) {
        final String cleanMessage = MessageUtils.stripColors(message);
        final int steps = 20;
        int delay = duration / steps;
        new BukkitRunnable(){
            int currentStep = 0;

            public void run() {
                if (this.currentStep >= steps) {
                    AnimationUtils.this.sendActionBar(player, message);
                    this.cancel();
                    return;
                }
                StringBuilder animatedMessage = new StringBuilder();
                for (int i = 0; i < cleanMessage.length(); ++i) {
                    char c = cleanMessage.charAt(i);
                    if (c == ' ') {
                        animatedMessage.append(' ');
                        continue;
                    }
                    double bounce = Math.abs(Math.sin((double)(this.currentStep + i) * 0.8)) * 3.0;
                    int spaces = (int)bounce;
                    animatedMessage.append(" ".repeat(spaces)).append(c);
                }
                AnimationUtils.this.sendActionBar(player, MessageUtils.colorize(animatedMessage.toString()));
                ++this.currentStep;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, (long)delay);
    }

    private void animateShake(final Player player, final String message, int duration) {
        final int steps = 15;
        int delay = duration / steps;
        new BukkitRunnable(){
            int currentStep = 0;

            public void run() {
                if (this.currentStep >= steps) {
                    AnimationUtils.this.sendActionBar(player, message);
                    this.cancel();
                    return;
                }
                int shakeAmount = ThreadLocalRandom.current().nextInt(-2, 3);
                String spaces = " ".repeat(Math.max(0, shakeAmount));
                String animatedMessage = spaces + message;
                AnimationUtils.this.sendActionBar(player, animatedMessage);
                ++this.currentStep;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, (long)delay);
    }

    private void animatePulse(final Player player, final String message, int duration) {
        final int steps = 20;
        int delay = duration / steps;
        new BukkitRunnable(){
            int currentStep = 0;

            public void run() {
                if (this.currentStep >= steps) {
                    AnimationUtils.this.sendActionBar(player, message);
                    this.cancel();
                    return;
                }
                double pulse = Math.sin((double)this.currentStep * 0.5) * 0.5 + 0.5;
                String animatedMessage = pulse > 0.7 ? message.replace("&", "&f&") : (pulse > 0.4 ? message.replace("&", "&e&") : message.replace("&", "&7&"));
                AnimationUtils.this.sendActionBar(player, animatedMessage);
                ++this.currentStep;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, (long)delay);
    }

    private void animateMatrix(final Player player, final String message, int duration) {
        final String cleanMessage = MessageUtils.stripColors(message);
        final int steps = 25;
        int delay = duration / steps;
        new BukkitRunnable(){
            int currentStep = 0;

            public void run() {
                if (this.currentStep >= steps) {
                    AnimationUtils.this.sendActionBar(player, message);
                    this.cancel();
                    return;
                }
                StringBuilder animatedMessage = new StringBuilder();
                for (int i = 0; i < cleanMessage.length(); ++i) {
                    char c = cleanMessage.charAt(i);
                    if (c == ' ') {
                        animatedMessage.append(' ');
                        continue;
                    }
                    if (ThreadLocalRandom.current().nextDouble() < 0.4) {
                        char matrixChar = (char)ThreadLocalRandom.current().nextInt(33, 127);
                        animatedMessage.append("&a").append(matrixChar);
                        continue;
                    }
                    animatedMessage.append(c);
                }
                AnimationUtils.this.sendActionBar(player, MessageUtils.colorize(animatedMessage.toString()));
                ++this.currentStep;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, (long)delay);
    }

    private void animateScramble(final Player player, final String message, int duration) {
        final String cleanMessage = MessageUtils.stripColors(message);
        final int steps = 20;
        int delay = duration / steps;
        new BukkitRunnable(){
            int currentStep = 0;

            public void run() {
                if (this.currentStep >= steps) {
                    AnimationUtils.this.sendActionBar(player, message);
                    this.cancel();
                    return;
                }
                StringBuilder animatedMessage = new StringBuilder();
                for (int i = 0; i < cleanMessage.length(); ++i) {
                    char c = cleanMessage.charAt(i);
                    if (c == ' ') {
                        animatedMessage.append(' ');
                        continue;
                    }
                    if (this.currentStep >= steps - 3) {
                        animatedMessage.append(c);
                        continue;
                    }
                    char randomChar = (char)ThreadLocalRandom.current().nextInt(33, 127);
                    animatedMessage.append("&c").append(randomChar);
                }
                AnimationUtils.this.sendActionBar(player, MessageUtils.colorize(animatedMessage.toString()));
                ++this.currentStep;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, (long)delay);
    }

    private String applyOpacity(String message, float opacity) {
        if (opacity >= 1.0f) {
            return message;
        }
        if (opacity >= 0.7f) {
            return message.replace("&", "&f&");
        }
        if (opacity >= 0.4f) {
            return message.replace("&", "&7&");
        }
        return message.replace("&", "&8&");
    }

    private String getRainbowColor(int index) {
        String[] colors = new String[]{"c", "6", "e", "a", "b", "d"};
        return colors[index % colors.length];
    }

    private void sendActionBar(Player player, String message) {
        boolean useActionBar = this.plugin.getConfig().getBoolean("animations.use-action-bar", true);
        if (useActionBar) {
            try {
                player.getClass().getMethod("sendActionBar", String.class).invoke((Object)player, MessageUtils.colorize(message));
            }
            catch (Exception e) {
                try {
                    player.sendTitle("", MessageUtils.colorize(message), 0, 20, 0);
                }
                catch (Exception e2) {
                    MessageUtils.sendMessage((CommandSender)player, message);
                }
            }
        } else {
            MessageUtils.sendMessage((CommandSender)player, message);
        }
    }

    public static List<String> getAvailableAnimations() {
        ArrayList<String> animations = new ArrayList<String>();
        animations.add("typing");
        animations.add("fade");
        animations.add("slide");
        animations.add("wave");
        animations.add("rainbow");
        animations.add("glitch");
        animations.add("typewriter");
        animations.add("bounce");
        animations.add("shake");
        animations.add("pulse");
        animations.add("matrix");
        animations.add("scramble");
        return animations;
    }
}

