/*
 * Decompiled with CFR 0.152.
 */
package com.github.mahmudindev.mcmod.dimensionfixer.world;

import com.github.mahmudindev.mcmod.dimensionfixer.DimensionFixer;
import com.github.mahmudindev.mcmod.dimensionfixer.config.Config;
import com.github.mahmudindev.mcmod.dimensionfixer.world.DimensionAliasData;
import com.github.mahmudindev.mcmod.dimensionfixer.world.DimensionTweakData;
import com.google.gson.Gson;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_5321;

public class DimensionManager {
    private static final Map<class_2960, DimensionAliasData> ALIASES = new HashMap<class_2960, DimensionAliasData>();
    private static final Map<class_2960, DimensionTweakData> TWEAKS = new HashMap<class_2960, DimensionTweakData>();

    public static void onResourceManagerReload(class_3300 manager) {
        ALIASES.clear();
        TWEAKS.clear();
        Config config = Config.getConfig();
        config.getAliases().forEach((dimension, alias) -> DimensionManager.setAlias(new class_2960(dimension), alias));
        config.getTweaks().forEach((dimension, tweak) -> DimensionManager.setTweak(new class_2960(dimension), tweak));
        Gson gson = new Gson();
        manager.method_41265("dimensionfixer", resourceLocation -> resourceLocation.method_12832().endsWith(".json")).forEach((resourceLocation, resources) -> resources.forEach(resource -> {
            String resourcePath = resourceLocation.method_12832().replaceFirst("^%s/".formatted("dimensionfixer"), "");
            try {
                String dimensionPath = resourcePath.substring(resourcePath.indexOf("/") + 1).replaceAll("\\.json$", "");
                if (resourcePath.startsWith("alias/")) {
                    DimensionManager.setAlias(resourceLocation.method_45136(dimensionPath), (DimensionAliasData)gson.fromJson(JsonParser.parseReader((Reader)resource.method_43039()), DimensionAliasData.class));
                } else if (resourcePath.startsWith("tweak/")) {
                    DimensionManager.setTweak(resourceLocation.method_45136(dimensionPath), (DimensionTweakData)gson.fromJson(JsonParser.parseReader((Reader)resource.method_43039()), DimensionTweakData.class));
                }
            }
            catch (IOException e) {
                DimensionFixer.LOGGER.error("Failed to read datapack", (Throwable)e);
            }
        }));
    }

    public static Map<class_2960, DimensionAliasData> getAliases() {
        return Map.copyOf(ALIASES);
    }

    public static DimensionAliasData getAlias(class_2960 dimension) {
        return ALIASES.get(dimension);
    }

    public static void setAlias(class_2960 dimension, DimensionAliasData alias) {
        if (!ALIASES.containsKey(dimension)) {
            ALIASES.put(dimension, new DimensionAliasData());
        }
        DimensionAliasData aliasX = DimensionManager.getAlias(dimension);
        aliasX.addAllDimensionType(alias.getDimensionTypes());
        aliasX.addAllDimension(alias.getDimensions());
    }

    public static boolean isAliasDimension(class_1937 dimensionA, class_5321<class_1937> dimensionB) {
        DimensionAliasData alias = DimensionManager.getAlias(dimensionB.method_29177());
        if (alias != null) {
            if (alias.containDimensionType((class_5321<class_2874>)dimensionA.method_44013())) {
                return true;
            }
            return alias.containDimension((class_5321<class_1937>)dimensionA.method_27983());
        }
        return false;
    }

    public static DimensionTweakData getTweak(class_5321<class_1937> dimension) {
        return TWEAKS.get(dimension.method_29177());
    }

    public static void setTweak(class_2960 dimension, DimensionTweakData tweak) {
        TWEAKS.put(dimension, tweak);
    }
}

