/*
 * Decompiled with CFR 0.152.
 */
package com.github.mahmudindev.mcmod.dimensionfixer.mixin;

import com.github.mahmudindev.mcmod.dimensionfixer.world.DimensionManager;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.mojang.authlib.GameProfile;
import java.util.LinkedList;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.portal.TeleportTransition;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends Player {
    private ServerPlayerMixin(Level level, BlockPos blockPos, float yRot, GameProfile gameProfile) {
        super(level, blockPos, yRot, gameProfile);
    }

    @Shadow
    public abstract ServerLevel serverLevel();

    @ModifyExpressionValue(method={"teleport(Lnet/minecraft/world/level/portal/TeleportTransition;)Lnet/minecraft/server/level/ServerPlayer;"}, at={@At(value="FIELD", target="Lnet/minecraft/world/level/Level;OVERWORLD:Lnet/minecraft/resources/ResourceKey;")})
    private ResourceKey<Level> changeDimensionNetherTrigger0(ResourceKey<Level> original) {
        ServerLevel serverLevel = this.serverLevel();
        if (DimensionManager.isAliasDimension((Level)serverLevel, (ResourceKey<Level>)Level.OVERWORLD)) {
            return serverLevel.dimension();
        }
        return original;
    }

    @ModifyExpressionValue(method={"teleport(Lnet/minecraft/world/level/portal/TeleportTransition;)Lnet/minecraft/server/level/ServerPlayer;"}, at={@At(value="FIELD", target="Lnet/minecraft/world/level/Level;NETHER:Lnet/minecraft/resources/ResourceKey;")})
    private ResourceKey<Level> changeDimensionNetherTrigger1(ResourceKey<Level> original, TeleportTransition teleportTransition) {
        ServerLevel serverLevel = teleportTransition.newLevel();
        if (DimensionManager.isAliasDimension((Level)serverLevel, (ResourceKey<Level>)Level.NETHER)) {
            return serverLevel.dimension();
        }
        return original;
    }

    @Inject(method={"triggerDimensionChangeTriggers(Lnet/minecraft/server/level/ServerLevel;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/advancements/critereon/ChangeDimensionTrigger;trigger(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/resources/ResourceKey;)V")})
    private void triggerDimensionChangeTriggersTrigger(ServerLevel serverLevel, CallbackInfo ci) {
        ResourceKey dimensionA0 = serverLevel.dimension();
        LinkedList dimensionA1List = new LinkedList();
        ResourceKey dimensionB0 = this.level().dimension();
        LinkedList dimensionB1List = new LinkedList();
        ResourceKey<DimensionType> dimensionTypeA0 = DimensionManager.getType((Level)serverLevel);
        ResourceKey<DimensionType> dimensionTypeB0 = DimensionManager.getType(this.level());
        DimensionManager.getAliases().forEach((k, v) -> {
            if (v.containDimension((ResourceKey<Level>)dimensionA0) || v.containDimensionType(dimensionTypeA0)) {
                dimensionA1List.add(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)k));
            }
            if (v.containDimension((ResourceKey<Level>)dimensionB0) || v.containDimensionType(dimensionTypeB0)) {
                dimensionB1List.add(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)k));
            }
        });
        dimensionA1List.forEach(dimensionA -> dimensionB1List.forEach(dimensionB -> {
            if (dimensionA == dimensionA0 && dimensionB == dimensionB0) {
                return;
            }
            CriteriaTriggers.CHANGED_DIMENSION.trigger((ServerPlayer)this, dimensionA, dimensionB);
        }));
    }

    @ModifyExpressionValue(method={"triggerDimensionChangeTriggers(Lnet/minecraft/server/level/ServerLevel;)V"}, at={@At(value="FIELD", target="Lnet/minecraft/world/level/Level;NETHER:Lnet/minecraft/resources/ResourceKey;", ordinal=0)})
    private ResourceKey<Level> triggerDimensionChangeTriggersNetherKey0(ResourceKey<Level> original, ServerLevel serverLevel) {
        if (DimensionManager.isAliasDimension((Level)serverLevel, (ResourceKey<Level>)Level.NETHER)) {
            return serverLevel.dimension();
        }
        return original;
    }

    @ModifyExpressionValue(method={"triggerDimensionChangeTriggers(Lnet/minecraft/server/level/ServerLevel;)V"}, at={@At(value="FIELD", target="Lnet/minecraft/world/level/Level;OVERWORLD:Lnet/minecraft/resources/ResourceKey;")})
    private ResourceKey<Level> triggerDimensionChangeTriggersOverworldKey(ResourceKey<Level> original) {
        Level level = this.level();
        if (DimensionManager.isAliasDimension(level, (ResourceKey<Level>)Level.OVERWORLD)) {
            return level.dimension();
        }
        return original;
    }

    @ModifyExpressionValue(method={"triggerDimensionChangeTriggers(Lnet/minecraft/server/level/ServerLevel;)V"}, at={@At(value="FIELD", target="Lnet/minecraft/world/level/Level;NETHER:Lnet/minecraft/resources/ResourceKey;", ordinal=1)})
    private ResourceKey<Level> triggerDimensionChangeTriggersNetherKey1(ResourceKey<Level> original) {
        Level level = this.level();
        if (DimensionManager.isAliasDimension(level, (ResourceKey<Level>)Level.NETHER)) {
            return level.dimension();
        }
        return original;
    }
}

