/*
 * Decompiled with CFR 0.152.
 */
package com.github.mahmudindev.mcmod.dimensionfixer.mixin;

import com.github.mahmudindev.mcmod.dimensionfixer.mixin.DerivedLevelDataAccessor;
import com.github.mahmudindev.mcmod.dimensionfixer.world.AliasDragonFight;
import com.github.mahmudindev.mcmod.dimensionfixer.world.DimensionManager;
import com.github.mahmudindev.mcmod.dimensionfixer.world.DimensionTweakData;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.raid.Raids;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.DerivedLevelData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WritableLevelData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={ServerLevel.class})
public abstract class ServerLevelMixin
extends Level
implements WorldGenLevel {
    @Shadow
    @Final
    private ServerLevelData serverLevelData;
    @Unique
    private AliasDragonFight aliasDragonFight;

    private ServerLevelMixin(WritableLevelData levelData, ResourceKey<Level> dimension, RegistryAccess registryAccess, Holder<DimensionType> dimensionTypeRegistration, boolean isClientSide, boolean isDebug, long biomeZoomSeed, int maxChainedNeighborUpdates) {
        super(levelData, dimension, registryAccess, dimensionTypeRegistration, isClientSide, isDebug, biomeZoomSeed, maxChainedNeighborUpdates);
    }

    @Shadow
    public abstract DimensionDataStorage getDataStorage();

    @WrapOperation(method={"<init>(Lnet/minecraft/server/MinecraftServer;Ljava/util/concurrent/Executor;Lnet/minecraft/world/level/storage/LevelStorageSource$LevelStorageAccess;Lnet/minecraft/world/level/storage/ServerLevelData;Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/world/level/dimension/LevelStem;ZJLjava/util/List;ZLnet/minecraft/world/RandomSequences;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/raid/Raids;getType(Lnet/minecraft/core/Holder;)Lnet/minecraft/world/level/saveddata/SavedDataType;")})
    private SavedDataType<Raids> initRaidsGetType(Holder<DimensionType> holder, Operation<SavedDataType<Raids>> original) {
        if (DimensionManager.isAliasDimension(this, (ResourceKey<Level>)Level.END)) {
            return (SavedDataType)original.call(new Object[]{this.registryAccess().lookupOrThrow(Registries.DIMENSION_TYPE).getOrThrow(BuiltinDimensionTypes.END)});
        }
        return (SavedDataType)original.call(new Object[]{holder});
    }

    @ModifyExpressionValue(method={"<init>(Lnet/minecraft/server/MinecraftServer;Ljava/util/concurrent/Executor;Lnet/minecraft/world/level/storage/LevelStorageSource$LevelStorageAccess;Lnet/minecraft/world/level/storage/ServerLevelData;Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/world/level/dimension/LevelStem;ZJLjava/util/List;ZLnet/minecraft/world/RandomSequences;)V"}, at={@At(value="FIELD", target="Lnet/minecraft/world/level/Level;END:Lnet/minecraft/resources/ResourceKey;")})
    private ResourceKey<Level> initDragonFightEndKey(ResourceKey<Level> original) {
        if (DimensionManager.isAliasDimension(this, (ResourceKey<Level>)Level.END)) {
            return this.dimension();
        }
        return original;
    }

    @ModifyExpressionValue(method={"<init>(Lnet/minecraft/server/MinecraftServer;Ljava/util/concurrent/Executor;Lnet/minecraft/world/level/storage/LevelStorageSource$LevelStorageAccess;Lnet/minecraft/world/level/storage/ServerLevelData;Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/world/level/dimension/LevelStem;ZJLjava/util/List;ZLnet/minecraft/world/RandomSequences;)V"}, at={@At(value="FIELD", target="Lnet/minecraft/world/level/dimension/BuiltinDimensionTypes;END:Lnet/minecraft/resources/ResourceKey;")})
    private ResourceKey<DimensionType> initDragonFightEndTypeKey(ResourceKey<DimensionType> original) {
        if (DimensionManager.isAliasDimension(this, (ResourceKey<Level>)Level.END)) {
            return DimensionManager.getType(this);
        }
        return original;
    }

    @WrapOperation(method={"<init>(Lnet/minecraft/server/MinecraftServer;Ljava/util/concurrent/Executor;Lnet/minecraft/world/level/storage/LevelStorageSource$LevelStorageAccess;Lnet/minecraft/world/level/storage/ServerLevelData;Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/world/level/dimension/LevelStem;ZJLjava/util/List;ZLnet/minecraft/world/RandomSequences;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/storage/WorldData;endDragonFightData()Lnet/minecraft/world/level/dimension/end/EndDragonFight$Data;")})
    private EndDragonFight.Data initDragonFightDataLoad(WorldData instance, Operation<EndDragonFight.Data> original) {
        if (this.dimension() != Level.END) {
            DimensionDataStorage dataStorage = this.getDataStorage();
            this.aliasDragonFight = (AliasDragonFight)dataStorage.computeIfAbsent(AliasDragonFight.TYPE);
            return this.aliasDragonFight.loadData();
        }
        return (EndDragonFight.Data)original.call(new Object[]{instance});
    }

    @WrapOperation(method={"tick(Ljava/util/function/BooleanSupplier;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;setDayTime(J)V")})
    private void tickSetDayTimeSleeping(ServerLevel instance, long value, Operation<Void> original) {
        long dayTime = this.levelData.getDayTime();
        original.call(new Object[]{instance, value});
        if (this.serverLevelData instanceof DerivedLevelData) {
            Boolean fixSleepingX;
            DimensionTweakData tweak;
            if (dayTime != this.levelData.getDayTime()) {
                return;
            }
            boolean fixSleeping = false;
            if (DimensionManager.isAliasDimension(this, (ResourceKey<Level>)Level.OVERWORLD)) {
                tweak = DimensionManager.getTweak((ResourceKey<Level>)Level.OVERWORLD);
                if (tweak != null) {
                    fixSleepingX = tweak.getFixSleeping();
                    if (fixSleepingX == null || fixSleepingX.booleanValue()) {
                        fixSleeping = true;
                    }
                } else {
                    fixSleeping = true;
                }
            }
            if (!fixSleeping) {
                tweak = DimensionManager.getTweak((ResourceKey<Level>)this.dimension());
                if (tweak == null) {
                    return;
                }
                fixSleepingX = tweak.getFixSleeping();
                if (fixSleepingX == null || !fixSleepingX.booleanValue()) {
                    return;
                }
            }
            DerivedLevelDataAccessor sld = (DerivedLevelDataAccessor)this.serverLevelData;
            ServerLevelData serverLevelData = sld.getWrapped();
            serverLevelData.setDayTime(value);
        }
    }

    @WrapOperation(method={"tick(Ljava/util/function/BooleanSupplier;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;resetWeatherCycle()V")})
    private void tickResetWeatherCycleSleeping(ServerLevel instance, Operation<Void> original) {
        boolean raining = this.levelData.isRaining();
        original.call(new Object[]{instance});
        if (this.serverLevelData instanceof DerivedLevelData) {
            Boolean fixSleepingX;
            DimensionTweakData tweak;
            if (raining != this.levelData.isRaining()) {
                return;
            }
            boolean fixSleeping = false;
            if (DimensionManager.isAliasDimension(this, (ResourceKey<Level>)Level.OVERWORLD)) {
                tweak = DimensionManager.getTweak((ResourceKey<Level>)Level.OVERWORLD);
                if (tweak != null) {
                    fixSleepingX = tweak.getFixSleeping();
                    if (fixSleepingX == null || fixSleepingX.booleanValue()) {
                        fixSleeping = true;
                    }
                } else {
                    fixSleeping = true;
                }
            }
            if (!fixSleeping) {
                tweak = DimensionManager.getTweak((ResourceKey<Level>)this.dimension());
                if (tweak == null) {
                    return;
                }
                fixSleepingX = tweak.getFixSleeping();
                if (fixSleepingX == null || !fixSleepingX.booleanValue()) {
                    return;
                }
            }
            DerivedLevelDataAccessor sld = (DerivedLevelDataAccessor)this.serverLevelData;
            ServerLevelData serverLevelData = sld.getWrapped();
            serverLevelData.setRainTime(0);
            serverLevelData.setRaining(false);
            serverLevelData.setThunderTime(0);
            serverLevelData.setThundering(false);
        }
    }

    @WrapOperation(method={"saveLevelData(Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/storage/WorldData;setEndDragonFightData(Lnet/minecraft/world/level/dimension/end/EndDragonFight$Data;)V")})
    private void saveLevelDataSetEndDragonFightDataSave(WorldData instance, EndDragonFight.Data data, Operation<Void> original) {
        if (this.dimension() != Level.END) {
            this.aliasDragonFight.saveData(data);
            return;
        }
        original.call(new Object[]{instance, data});
    }

    @WrapMethod(method={"isFlat()Z"})
    public boolean isFlatOverride(Operation<Boolean> original) {
        Boolean overrideFlatCheck;
        DimensionTweakData tweak = DimensionManager.getTweak((ResourceKey<Level>)this.dimension());
        if (tweak != null && (overrideFlatCheck = tweak.getOverrideFlatCheck()) != null) {
            return overrideFlatCheck;
        }
        return (Boolean)original.call(new Object[0]);
    }
}

