/*
 * Decompiled with CFR 0.152.
 */
package com.github.mahmudindev.mcmod.dimensionfixer.mixin;

import com.github.mahmudindev.mcmod.dimensionfixer.base.IBlockPos;
import com.github.mahmudindev.mcmod.dimensionfixer.world.DimensionManager;
import com.github.mahmudindev.mcmod.dimensionfixer.world.DimensionTweakData;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.PortalForcer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={PortalForcer.class})
public abstract class PortalForcerMixin {
    @Shadow
    @Final
    private ServerLevel f_77648_;

    @ModifyExpressionValue(method={"findPortalAround"}, at={@At(value="CONSTANT", args={"intValue=16"})})
    private int findClosestPortalPositionScale16(int original, BlockPos blockPos) {
        DimensionTweakData tweak;
        Level levelX = ((IBlockPos)blockPos).dimensionfixer$getLevel();
        if (levelX != null && (tweak = DimensionManager.getTweak((ResourceKey<Level>)this.f_77648_.m_46472_())) != null) {
            Boolean fixPortalSearchRadius = tweak.getFixPortalSearchRadius();
            if (fixPortalSearchRadius != null && !fixPortalSearchRadius.booleanValue()) {
                return original;
            }
            double scaleA = this.f_77648_.m_6042_().f_63859_();
            double scaleB = levelX.m_6042_().f_63859_();
            return (int)Math.round(scaleA * scaleB / scaleA * 16.0);
        }
        return original;
    }

    @ModifyExpressionValue(method={"findPortalAround"}, at={@At(value="CONSTANT", args={"intValue=128"})})
    private int findClosestPortalPositionScale128(int original, BlockPos blockPos) {
        DimensionTweakData tweak;
        Level levelX = ((IBlockPos)blockPos).dimensionfixer$getLevel();
        if (levelX != null && (tweak = DimensionManager.getTweak((ResourceKey<Level>)this.f_77648_.m_46472_())) != null) {
            Boolean fixPortalSearchRadius = tweak.getFixPortalSearchRadius();
            if (fixPortalSearchRadius != null && !fixPortalSearchRadius.booleanValue()) {
                return original;
            }
            double scaleA = this.f_77648_.m_6042_().f_63859_();
            double scaleB = levelX.m_6042_().f_63859_();
            return (int)Math.round(scaleA * scaleB / scaleA * 16.0);
        }
        return original;
    }
}

