/*
 * Decompiled with CFR 0.152.
 */
package com.github.mahmudindev.mcmod.dimensionfixer.config;

import com.github.mahmudindev.mcmod.dimensionfixer.DimensionFixer;
import com.github.mahmudindev.mcmod.dimensionfixer.DimensionFixerExpectPlatform;
import com.github.mahmudindev.mcmod.dimensionfixer.world.DimensionAliasData;
import com.github.mahmudindev.mcmod.dimensionfixer.world.DimensionTweakData;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2874;
import net.minecraft.class_5321;
import net.minecraft.class_7134;

public class Config {
    private static final Path CONFIG_DIR = DimensionFixerExpectPlatform.getConfigDir();
    private static Config CONFIG = new Config();
    private final Map<String, DimensionAliasData> aliases = new HashMap<String, DimensionAliasData>();
    private final Map<String, DimensionTweakData> tweaks = new HashMap<String, DimensionTweakData>();

    private void defaults() {
        DimensionAliasData alias0 = new DimensionAliasData();
        alias0.addDimensionType((class_5321<class_2874>)class_7134.field_37666);
        alias0.addDimensionType((class_5321<class_2874>)class_7134.field_37669);
        this.aliases.put(String.valueOf(class_1937.field_25179.method_29177()), alias0);
        DimensionAliasData alias1 = new DimensionAliasData();
        alias1.addDimensionType((class_5321<class_2874>)class_7134.field_37667);
        this.aliases.put(String.valueOf(class_1937.field_25180.method_29177()), alias1);
        DimensionAliasData alias2 = new DimensionAliasData();
        alias2.addDimensionType((class_5321<class_2874>)class_7134.field_37668);
        this.aliases.put(String.valueOf(class_1937.field_25181.method_29177()), alias2);
        DimensionTweakData tweak0 = new DimensionTweakData();
        tweak0.setFixSleeping(true);
        tweak0.setFixPortalSearchRadius(true);
        this.tweaks.put("dimensionfixer:dimension", tweak0);
    }

    public Map<String, DimensionAliasData> getAliases() {
        return this.aliases;
    }

    public Map<String, DimensionTweakData> getTweaks() {
        return this.tweaks;
    }

    public static void load() {
        Gson parser = new GsonBuilder().setPrettyPrinting().create();
        File configFile = CONFIG_DIR.resolve("dimensionfixer.json").toFile();
        if (!configFile.exists()) {
            CONFIG.defaults();
            try (FileWriter writer = new FileWriter(configFile);){
                writer.write(parser.toJson((Object)CONFIG));
            }
            catch (IOException e) {
                DimensionFixer.LOGGER.error("Failed to write config", (Throwable)e);
            }
        } else {
            try (FileReader reader = new FileReader(configFile);){
                CONFIG = (Config)parser.fromJson((Reader)reader, Config.class);
            }
            catch (IOException e) {
                DimensionFixer.LOGGER.error("Failed to read config", (Throwable)e);
            }
        }
    }

    public static Config getConfig() {
        return CONFIG;
    }
}

