/*
 * Decompiled with CFR 0.152.
 */
package com.github.mahmudindev.mcmod.dimensionfixer.mixin;

import com.github.mahmudindev.mcmod.dimensionfixer.world.DimensionManager;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={Minecraft.class})
public abstract class MinecraftClientMixin {
    @Shadow
    @Nullable
    public LocalPlayer player;

    @ModifyExpressionValue(method={"getSituationalMusic()Lnet/minecraft/sounds/Music;"}, at={@At(value="FIELD", target="Lnet/minecraft/world/level/Level;END:Lnet/minecraft/resources/ResourceKey;")})
    private ResourceKey<Level> getSituationalMusicEndKey(ResourceKey<Level> original) {
        Level level = this.player.level();
        if (DimensionManager.isAliasDimension(level, (ResourceKey<Level>)Level.END)) {
            return level.dimension();
        }
        return original;
    }

    @ModifyExpressionValue(method={"getSituationalMusic()Lnet/minecraft/sounds/Music;"}, at={@At(value="FIELD", target="Lnet/minecraft/world/level/Level;NETHER:Lnet/minecraft/resources/ResourceKey;")})
    private ResourceKey<Level> getSituationalMusicNetherKey(ResourceKey<Level> original) {
        Level level = this.player.level();
        if (DimensionManager.isAliasDimension(level, (ResourceKey<Level>)Level.NETHER)) {
            return level.dimension();
        }
        return original;
    }
}

