/*
 * Decompiled with CFR 0.152.
 */
package com.miningworldupgrade;

import com.miningworldupgrade.AlgorithmVein;
import com.mojang.serialization.Codec;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="miningworldupgrade")
public class MiningWorldUpgrade {
    private static MiningWorldUpgrade instance;
    public static DeferredRegister<Feature<?>> FEATURES;
    private final DeferredHolder<Feature<?>, AlgorithmVein> vein;
    public static List<ChunkAccess> chunkAccessList;

    public MiningWorldUpgrade(ModContainer container, IEventBus modEventBus) {
        NeoForge.EVENT_BUS.register((Object)this);
        FEATURES.register(modEventBus);
        this.vein = FEATURES.register("vein", () -> new AlgorithmVein((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC));
    }

    @SubscribeEvent
    public void onLevelTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        ResourceKey dimension = event.getLevel().dimension();
        if (!dimension.location().getNamespace().equals("miningworld")) {
            return;
        }
        int maxPerTick = 2;
        for (int processed = 0; !chunkAccessList.isEmpty() && processed < maxPerTick; ++processed) {
            ChunkAccess chunkAccess = chunkAccessList.removeFirst();
            ChunkGenerator generator = level2.getChunkSource().getGenerator();
            BlockPos pos = new BlockPos(chunkAccess.getPos().x * 16, 50, chunkAccess.getPos().z * 16);
            try {
                ((AlgorithmVein)((Object)this.vein.get())).place((FeaturePlaceContext<NoneFeatureConfiguration>)new FeaturePlaceContext(null, (WorldGenLevel)level2, generator, event.getLevel().random, pos, null));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void registerChunks(ChunkEvent.Load event) {
        ResourceKey dimension = event.getChunk().getLevel().dimension();
        if (!dimension.location().getNamespace().equals("miningworld")) {
            return;
        }
        if (event.isNewChunk()) {
            chunkAccessList.add(event.getChunk());
        }
    }

    static {
        FEATURES = DeferredRegister.create((ResourceKey)Registries.FEATURE, (String)"miningworldupgrade");
        chunkAccessList = new LinkedList<ChunkAccess>();
    }
}

