/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo;

import com.esmods.keepersofthestonestwo.init.PowerModMobEffects;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber
public class LightPassiveSkills {
    private static final Map<UUID, Long> dashCooldowns = new HashMap<UUID, Long>();

    @SubscribeEvent
    public static void onLivingDamaged(LivingDamageEvent.Pre event) {
        LivingEntity target = event.getEntity();
        DamageSource source = event.getSource();
        Entity entity = source.getEntity();
        if (entity instanceof Player) {
            long lastUsed;
            Player attacker = (Player)entity;
            if (!LightPassiveSkills.hasLightMasterAndEnoughLight(attacker)) {
                return;
            }
            float originalDamage = event.getOriginalDamage();
            event.setNewDamage(originalDamage * 1.2f);
            UUID playerId = attacker.getUUID();
            long currentTime = attacker.level().getGameTime();
            if (dashCooldowns.containsKey(playerId) && currentTime - (lastUsed = dashCooldowns.get(playerId).longValue()) < 500L) {
                return;
            }
            if (attacker.getRandom().nextFloat() < 0.1f) {
                attacker.addEffect(new MobEffectInstance(PowerModMobEffects.DASH, 140, 1, false, false));
                dashCooldowns.put(playerId, currentTime);
            }
        }
    }

    private static boolean hasLightMasterAndEnoughLight(Player player) {
        if (!player.hasEffect(PowerModMobEffects.LIGHT_MASTER)) {
            return false;
        }
        int lightLevel = player.level().getMaxLocalRawBrightness(player.blockPosition());
        return lightLevel >= 12;
    }
}

