/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo;

import com.esmods.keepersofthestonestwo.init.PowerModMobEffects;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class MistPassiveSkills {
    private static final int REGEN_DURATION = 300;
    private static final int REGEN_COOLDOWN = 900;
    private static final int WATER_RADIUS = 8;
    private static final Map<UUID, Long> lastRegenTime = new HashMap<UUID, Long>();

    private static boolean isActive(Player player) {
        BlockPos pos;
        if (player.level().isClientSide()) {
            return false;
        }
        if (!player.hasEffect(PowerModMobEffects.MIST_MASTER)) {
            return false;
        }
        Level level = player.level();
        Biome biome = (Biome)level.getBiome(pos = player.blockPosition()).value();
        if (biome.getModifiedClimateSettings().downfall() >= 0.6f) {
            return true;
        }
        for (int x = -8; x <= 8; ++x) {
            for (int y = -8; y <= 8; ++y) {
                for (int z = -8; z <= 8; ++z) {
                    if (!level.getBlockState(pos.offset(x, y, z)).is(Blocks.WATER)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isMorning(Player player) {
        long dayTime = player.level().getDayTime() % 24000L;
        return dayTime >= 1000L && dayTime <= 12000L;
    }

    @SubscribeEvent
    public static void onPlayerTakeDamage(LivingIncomingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!MistPassiveSkills.isActive(player)) {
            return;
        }
        if (player.getRandom().nextFloat() < 0.1f) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player.level().isClientSide()) {
            return;
        }
        if (!MistPassiveSkills.isActive(player)) {
            return;
        }
        if (!MistPassiveSkills.isMorning(player)) {
            return;
        }
        UUID playerId = player.getUUID();
        long currentTime = player.level().getGameTime();
        Long lastTime = lastRegenTime.get(playerId);
        if (lastTime == null || currentTime - lastTime >= 900L) {
            player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 300, 1, false, true));
            lastRegenTime.put(playerId, currentTime);
        }
    }
}

