/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo;

import com.esmods.keepersofthestonestwo.init.PowerModMobEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber
public class MushroomsPassiveSkills {
    private static final int NAUSEA_DURATION = 400;
    private static final int SEARCH_RADIUS = 16;

    private static boolean isActive(Player player) {
        if (player.level().isClientSide()) {
            return false;
        }
        if (!player.hasEffect(PowerModMobEffects.MUSHROOMS_MASTER)) {
            return false;
        }
        BlockPos center = player.blockPosition();
        for (int x = -16; x <= 16; ++x) {
            for (int y = -16; y <= 16; ++y) {
                for (int z = -16; z <= 16; ++z) {
                    BlockPos pos = center.offset(x, y, z);
                    BlockState state = player.level().getBlockState(pos);
                    if (!state.is(Blocks.RED_MUSHROOM) && !state.is(Blocks.BROWN_MUSHROOM) && !state.is(Blocks.CRIMSON_FUNGUS) && !state.is(Blocks.WARPED_FUNGUS) && !state.is(Blocks.MUSHROOM_STEM) && !state.is(Blocks.BROWN_MUSHROOM_BLOCK) && !state.is(Blocks.RED_MUSHROOM_BLOCK) && !state.is(Blocks.MYCELIUM) && !state.is(Blocks.CRIMSON_NYLIUM) && !state.is(Blocks.WARPED_NYLIUM) && !state.is(BlockTags.MUSHROOM_GROW_BLOCK)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void onPlayerAttack(LivingDamageEvent.Pre event) {
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = livingEntity;
        if (!MushroomsPassiveSkills.isActive(attacker)) {
            return;
        }
        event.setNewDamage(event.getOriginalDamage() * 1.1f);
        if (attacker.getRandom().nextFloat() < 0.15f) {
            target.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 400, 3, false, true));
        }
    }

    @SubscribeEvent
    public static void onPlayerTakeDamage(LivingDamageEvent.Pre event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!MushroomsPassiveSkills.isActive(player)) {
            return;
        }
        if (player.getRandom().nextFloat() < 0.15f) {
            int current = player.getFoodData().getFoodLevel();
            player.getFoodData().setFoodLevel(Math.min(20, current + 4));
        }
    }
}

