/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo;

import com.esmods.keepersofthestonestwo.init.PowerModMobEffects;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber
public class MusicPassiveSkills {
    private static final int WEAKNESS_DURATION = 200;
    private static final int REGEN_DURATION = 300;
    private static final int REGEN_COOLDOWN = 1800;
    private static final int SEARCH_RADIUS = 16;
    private static final Map<UUID, Long> lastRegenTime = new HashMap<UUID, Long>();

    private static boolean isActive(Player player) {
        if (player.level().isClientSide()) {
            return false;
        }
        if (!player.hasEffect(PowerModMobEffects.MUSIC_MASTER)) {
            return false;
        }
        BlockPos center = player.blockPosition();
        for (int x = -16; x <= 16; ++x) {
            for (int y = -16; y <= 16; ++y) {
                for (int z = -16; z <= 16; ++z) {
                    BlockPos pos = center.offset(x, y, z);
                    Block block = player.level().getBlockState(pos).getBlock();
                    if (block != Blocks.NOTE_BLOCK && block != Blocks.JUKEBOX) continue;
                    return true;
                }
            }
        }
        for (ItemStack stack : player.getInventory().items) {
            if (stack.isEmpty() || !stack.is(Tags.Items.MUSIC_DISCS)) continue;
            return true;
        }
        ItemStack offhand = player.getOffhandItem();
        return !offhand.isEmpty() && offhand.is(Tags.Items.MUSIC_DISCS);
    }

    @SubscribeEvent
    public static void onPlayerAttack(LivingDamageEvent.Pre event) {
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = livingEntity;
        if (!MusicPassiveSkills.isActive(attacker)) {
            return;
        }
        event.setNewDamage(event.getOriginalDamage() * 1.2f);
        if (attacker.getRandom().nextFloat() < 0.1f) {
            target.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 200, 2, false, true));
        }
    }

    @SubscribeEvent
    public static void onPlayerTakeDamage(LivingDamageEvent.Pre event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!MusicPassiveSkills.isActive(player)) {
            return;
        }
        UUID id = player.getUUID();
        long now = player.level().getGameTime();
        Long last = lastRegenTime.get(id);
        if ((last == null || now - last >= 1800L) && player.getRandom().nextFloat() < 0.1f) {
            player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 300, 1, false, true));
            lastRegenTime.put(id, now);
        }
    }
}

