/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo;

import com.esmods.keepersofthestonestwo.init.PowerModMobEffects;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber
public class SandPassiveSkills {
    private static final int EFFECT_DURATION = 200;

    private static boolean isActive(Player player) {
        if (player.level().isClientSide()) {
            return false;
        }
        if (!player.hasEffect(PowerModMobEffects.SAND_MASTER)) {
            return false;
        }
        Holder biome = player.level().getBiome(player.blockPosition());
        return biome.is(BiomeTags.HAS_VILLAGE_DESERT) || biome.is(BiomeTags.IS_BADLANDS);
    }

    @SubscribeEvent
    public static void onPlayerAttack(LivingDamageEvent.Pre event) {
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = livingEntity;
        if (!SandPassiveSkills.isActive(attacker)) {
            return;
        }
        if (attacker.getRandom().nextFloat() < 0.1f) {
            Holder[] effects = new Holder[]{MobEffects.BLINDNESS, MobEffects.MOVEMENT_SLOWDOWN, PowerModMobEffects.STUN};
            Holder chosen = effects[attacker.getRandom().nextInt(effects.length)];
            target.addEffect(new MobEffectInstance(chosen, 200, 0, false, true));
        }
    }

    @SubscribeEvent
    public static void onPlayerTakeDamage(LivingDamageEvent.Pre event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!SandPassiveSkills.isActive(player)) {
            return;
        }
        DamageSource source = event.getSource();
        float original = event.getOriginalDamage();
        if (source.is(DamageTypes.FALL)) {
            event.setNewDamage(original * 0.25f);
        } else if (source.getEntity() instanceof LivingEntity || source.getDirectEntity() instanceof LivingEntity) {
            event.setNewDamage(original * 0.75f);
        }
    }
}

