/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo;

import com.esmods.keepersofthestonestwo.init.PowerModMobEffects;
import com.esmods.keepersofthestonestwo.network.PowerModVariables;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

@EventBusSubscriber
public class TimePassiveSkills {
    private static final Map<UUID, UUID> countdownOwner = new HashMap<UUID, UUID>();
    private static final int COUNTDOWN_DURATION = 60;
    private static final int DASH_DURATION = 100;

    private static boolean isTimeMasterActive(Player player) {
        if (player.level().isClientSide()) {
            return false;
        }
        MobEffectInstance effect = player.getEffect(PowerModMobEffects.TIME_MASTER);
        if (effect == null) {
            return false;
        }
        int duration = effect.getDuration();
        int amplifier = effect.getAmplifier();
        PowerModVariables.PlayerVariables playerVars = (PowerModVariables.PlayerVariables)player.getData(PowerModVariables.PLAYER_VARIABLES);
        double TIME_MASTER_MAX_DURATION = playerVars.master_effect_duration * 20.0;
        return (double)duration <= TIME_MASTER_MAX_DURATION / 2.0;
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent.Pre event) {
        LivingEntity target = event.getEntity();
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        if (target.level().isClientSide()) {
            return;
        }
        if (!TimePassiveSkills.isTimeMasterActive(attacker)) {
            return;
        }
        float originalDamage = event.getOriginalDamage();
        event.setNewDamage(originalDamage * 1.5f);
        if (attacker.getRandom().nextFloat() < 0.2f) {
            attacker.addEffect(new MobEffectInstance(PowerModMobEffects.DASH, 100, 2, false, false));
        }
        if (attacker.getRandom().nextFloat() < 0.25f) {
            target.addEffect(new MobEffectInstance(PowerModMobEffects.COUNTDOWN, 60, 0, false, true));
            countdownOwner.put(target.getUUID(), attacker.getUUID());
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        float maxHealth;
        ServerPlayer serverPlayer;
        ServerLevel serverLevel;
        Player attacker;
        LivingEntity target = event.getEntity();
        if (target.level().isClientSide()) {
            return;
        }
        if (!target.hasEffect(PowerModMobEffects.COUNTDOWN)) {
            return;
        }
        UUID attackerId = countdownOwner.remove(target.getUUID());
        if (attackerId == null) {
            return;
        }
        Level level = target.level();
        if (level instanceof ServerLevel && (attacker = (serverLevel = (ServerLevel)level).getPlayerByUUID(attackerId)) instanceof ServerPlayer && !(serverPlayer = (ServerPlayer)attacker).isDeadOrDying() && (maxHealth = target.getMaxHealth()) > 0.0f) {
            serverPlayer.heal(maxHealth);
        }
    }
}

