/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo.item;

import com.esmods.keepersofthestonestwo.entity.SmokeMusketProjectileEntity;
import com.esmods.keepersofthestonestwo.procedures.RemoveForbiddenItemProcedure;
import com.esmods.keepersofthestonestwo.procedures.SmokeMusketPriVystrielieSnariadomIzPriedmietaProcedure;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class SmokeMusketItem
extends Item {
    public SmokeMusketItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public UseAnim getUseAnimation(ItemStack itemstack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack itemstack, LivingEntity livingEntity) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = InteractionResultHolder.fail((Object)entity.getItemInHand(hand));
        if (entity.getAbilities().instabuild || this.findAmmo(entity) != ItemStack.EMPTY) {
            ar = InteractionResultHolder.success((Object)entity.getItemInHand(hand));
            entity.startUsingItem(hand);
        }
        return ar;
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        RemoveForbiddenItemProcedure.execute((LevelAccessor)world, entity, itemstack);
    }

    public void releaseUsing(ItemStack itemstack, Level world, LivingEntity entity, int time) {
        if (!world.isClientSide() && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ItemStack stack = this.findAmmo((Player)player);
            if (player.getAbilities().instabuild || stack != ItemStack.EMPTY) {
                SmokeMusketProjectileEntity projectile = SmokeMusketProjectileEntity.shoot(world, entity, world.getRandom());
                if (player.getAbilities().instabuild) {
                    projectile.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                } else if (stack.isDamageableItem()) {
                    if (world instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)world;
                        stack.hurtAndBreak(1, serverLevel, player, _stkprov -> {});
                    }
                } else {
                    stack.shrink(1);
                }
                SmokeMusketPriVystrielieSnariadomIzPriedmietaProcedure.execute((Entity)entity);
            }
        }
    }

    private ItemStack findAmmo(Player player) {
        return new ItemStack((ItemLike)SmokeMusketProjectileEntity.PROJECTILE_ITEM.getItem());
    }
}

