/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo;

import com.esmods.keepersofthestonestwo.init.PowerModMobEffects;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber
public class DarknessPassiveSkills {
    private static final int EFFECT_DURATION = 200;

    private static boolean isInDarkness(Player player) {
        Level level = player.level();
        if (level.getMaxLocalRawBrightness(player.blockPosition()) <= 7) {
            return true;
        }
        if (level.dimension() == Level.OVERWORLD) {
            long time = level.getDayTime() % 24000L;
            return time >= 13000L && time < 23000L;
        }
        return false;
    }

    private static boolean isActive(Player player) {
        return !player.level().isClientSide() && player.hasEffect(PowerModMobEffects.DARKNESS_MASTER) && DarknessPassiveSkills.isInDarkness(player);
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent.Pre event) {
        Player attacker;
        Entity entity;
        Player player;
        LivingEntity target = event.getEntity();
        if (target.level().isClientSide()) {
            return;
        }
        if (target instanceof Player && DarknessPassiveSkills.isActive(player = (Player)target)) {
            event.setNewDamage(event.getOriginalDamage() * 0.55f);
        }
        if ((entity = event.getSource().getEntity()) instanceof Player && DarknessPassiveSkills.isActive(attacker = (Player)entity)) {
            event.setNewDamage(event.getOriginalDamage() * 1.35f);
            if (attacker.getRandom().nextFloat() < 0.3f) {
                Holder[] effects = new Holder[]{MobEffects.WEAKNESS, MobEffects.MOVEMENT_SLOWDOWN, PowerModMobEffects.STUN, MobEffects.BLINDNESS};
                Holder chosen = effects[attacker.getRandom().nextInt(effects.length)];
                int amplifier = 1;
                if (chosen == MobEffects.BLINDNESS || chosen == PowerModMobEffects.STUN.get()) {
                    amplifier = 0;
                }
                if (target instanceof LivingEntity) {
                    LivingEntity livingTarget = target;
                    livingTarget.addEffect(new MobEffectInstance(chosen, 200, amplifier, false, true));
                }
            }
        }
    }
}

