/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo;

import com.esmods.keepersofthestonestwo.init.PowerModMobEffects;
import com.esmods.keepersofthestonestwo.network.PowerModVariables;
import java.util.UUID;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber
public class MindPassiveSkills {
    private static final int DASH_DURATION = 300;
    private static final int SEARCH_RADIUS = 16;

    private static boolean hasMindMaster(Player player) {
        return !player.level().isClientSide() && player.hasEffect(PowerModMobEffects.MIND_MASTER);
    }

    private static Player getHypnotizer(Player hypnotized) {
        String ownerIdStr = ((PowerModVariables.PlayerVariables)hypnotized.getData(PowerModVariables.PLAYER_VARIABLES)).mind_player_owner;
        if (ownerIdStr == null || ownerIdStr.isEmpty()) {
            return null;
        }
        try {
            UUID ownerId = UUID.fromString(ownerIdStr);
            Player owner = hypnotized.level().getPlayerByUUID(ownerId);
            return owner;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static boolean isHypnotizedAndControlled(Player player) {
        return MindPassiveSkills.getHypnotizer(player) != null;
    }

    private static boolean isControlledHypnotizedPlayerNearby(Player mindMaster) {
        return mindMaster.level().getEntitiesOfClass(Player.class, mindMaster.getBoundingBox().inflate(16.0)).stream().anyMatch(p -> !p.getUUID().equals(mindMaster.getUUID()) && MindPassiveSkills.isHypnotizedAndControlled(p));
    }

    @SubscribeEvent
    public static void onPlayerAttack(LivingDamageEvent.Pre event) {
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (attacker.level().isClientSide()) {
            return;
        }
        boolean applyDash = false;
        if (MindPassiveSkills.hasMindMaster(attacker) && MindPassiveSkills.isControlledHypnotizedPlayerNearby(attacker)) {
            event.setNewDamage(event.getOriginalDamage() * 1.2f);
            if (attacker.getRandom().nextFloat() < 0.15f) {
                applyDash = true;
            }
        } else {
            Player hypnotizer = MindPassiveSkills.getHypnotizer(attacker);
            if (hypnotizer != null && MindPassiveSkills.hasMindMaster(hypnotizer) && hypnotizer.distanceToSqr((Entity)attacker) <= 256.0) {
                event.setNewDamage(event.getOriginalDamage() * 1.1f);
                if (attacker.getRandom().nextFloat() < 0.15f) {
                    applyDash = true;
                }
            }
        }
        if (applyDash) {
            attacker.addEffect(new MobEffectInstance(PowerModMobEffects.DASH, 300, 0, false, false));
        }
    }
}

