/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforgespi.language.IModInfo;

@EventBusSubscriber
public class ModVersionManager {
    private static final String PROJECT_ID = "keepers-of-the-stones-2";
    private static final String MINECRAFT_VERSION = ModVersionManager.getMinecraftVersion();
    private static final String CURRENT_VERSION = ModVersionManager.getCurrentVersion();

    private static VersionType getVersionType(String version) {
        if (version == null || version.isEmpty()) {
            return VersionType.UNKNOWN;
        }
        if (Pattern.matches("^\\d+\\.\\d+\\.\\d+$", version)) {
            return VersionType.RELEASE;
        }
        return VersionType.OTHER;
    }

    public static void checkForUpdates(ServerPlayer player) {
        if (ModVersionManager.getVersionType(CURRENT_VERSION) != VersionType.RELEASE) {
            return;
        }
        try {
            List<VersionData> allVersions = ModVersionManager.fetchVersionsFromModrinth();
            if (allVersions.isEmpty()) {
                System.out.println("Couldn't get a list of versions.");
                return;
            }
            Version current = new Version(CURRENT_VERSION);
            Version latestRelease = null;
            for (VersionData data : allVersions) {
                Version candidate;
                if (!ModVersionManager.isMinecraftVersionSupported(data.gameVersions) || ModVersionManager.getVersionType(data.versionNumber) != VersionType.RELEASE || (candidate = new Version(data.versionNumber)).compareTo(current) <= 0 || latestRelease != null && candidate.compareTo(latestRelease) <= 0) continue;
                latestRelease = candidate;
            }
            if (latestRelease == null) {
                System.out.println("No newer RELEASE version found.");
                return;
            }
            String changelog = ModVersionManager.getVersionChangelog(allVersions, latestRelease.toString());
            ModVersionManager.sendUpdateMessage(player, latestRelease, changelog);
            System.out.println("Newer RELEASE version found: " + String.valueOf(latestRelease));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean isMinecraftVersionSupported(List<String> gameVersions) {
        return gameVersions.contains(MINECRAFT_VERSION);
    }

    private static void sendUpdateMessage(ServerPlayer player, Version latest, String changelog) {
        MutableComponent message = Component.translatable((String)"power.modupdater.new_release").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)65450))).append((Component)Component.literal((String)latest.toString()).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xFFFF55)))).append((Component)Component.translatable((String)"power.modupdater.click_event").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAAAAAA)).withUnderlined(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://modrinth.com/project/keepers-of-the-stones-2")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)("\nWhat's new:\n" + changelog))))));
        player.sendSystemMessage((Component)message);
    }

    private static String getVersionChangelog(List<VersionData> allVersions, String version) {
        return allVersions.stream().filter(v -> v.versionNumber.equals(version)).filter(v -> ModVersionManager.isMinecraftVersionSupported(v.gameVersions)).map(v -> v.changelog != null ? v.changelog : "").findFirst().orElse("Changelog not available for your Minecraft version.");
    }

    private static List<VersionData> fetchVersionsFromModrinth() throws IOException {
        URL url = new URL("https://api.modrinth.com/v2/project/keepers-of-the-stones-2/version");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("User-Agent", "KeepersOfTheStonesII/UpdateChecker");
        StringBuilder response = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
        }
        return ModVersionManager.parseVersionsFromJson(response.toString());
    }

    private static List<VersionData> parseVersionsFromJson(String json) {
        JsonArray array = JsonParser.parseString((String)json).getAsJsonArray();
        ArrayList<VersionData> result = new ArrayList<VersionData>();
        for (JsonElement element : array) {
            JsonObject obj = element.getAsJsonObject();
            String versionNumber = obj.get("version_number").getAsString();
            String changelog = obj.has("changelog") ? obj.get("changelog").getAsString() : "";
            JsonArray gameVersionsArray = obj.getAsJsonArray("game_versions");
            ArrayList<String> gameVersions = new ArrayList<String>();
            for (JsonElement el : gameVersionsArray) {
                gameVersions.add(el.getAsString());
            }
            result.add(new VersionData(versionNumber, changelog, gameVersions));
        }
        return result;
    }

    private static String getCurrentVersion() {
        for (IModInfo mod : ModList.get().getMods()) {
            if (!"power".equals(mod.getModId())) continue;
            return mod.getVersion().toString();
        }
        return "0.0.0";
    }

    private static String getMinecraftVersion() {
        for (IModInfo mod : ModList.get().getMods()) {
            if (!"minecraft".equals(mod.getModId())) continue;
            return mod.getVersion().toString();
        }
        return "0.0.0";
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ModVersionManager.executeCheckForUpdates((Event)event, (Entity)event.getEntity());
        ModVersionManager.executeBetaWarning((Event)event, (Entity)event.getEntity());
    }

    private static void executeCheckForUpdates(@Nullable Event event, Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            ModVersionManager.checkForUpdates(serverPlayer);
        }
    }

    private static void executeBetaWarning(@Nullable Event event, Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (ModVersionManager.getVersionType(CURRENT_VERSION) != VersionType.RELEASE) {
                player.displayClientMessage((Component)Component.translatable((String)"power.modupdater.beta_detect"), false);
            }
        }
    }

    static enum VersionType {
        RELEASE,
        OTHER,
        UNKNOWN;

    }

    static class Version
    implements Comparable<Version> {
        private final String raw;
        private final int[] parts;

        public Version(String version) {
            this.raw = version;
            this.parts = Version.parseVersion(version);
        }

        private static int[] parseVersion(String v) {
            String clean = v.contains("-") ? v.substring(0, v.indexOf(45)) : v;
            String[] split = clean.split("\\.");
            int[] result = new int[Math.min(split.length, 3)];
            for (int i = 0; i < result.length; ++i) {
                try {
                    result[i] = Integer.parseInt(split[i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    result[i] = 0;
                }
            }
            return result;
        }

        @Override
        public int compareTo(Version o) {
            int len = Math.max(this.parts.length, o.parts.length);
            for (int i = 0; i < len; ++i) {
                int b;
                int a = i < this.parts.length ? this.parts[i] : 0;
                int n = b = i < o.parts.length ? o.parts[i] : 0;
                if (a == b) continue;
                return Integer.compare(a, b);
            }
            return 0;
        }

        public String toString() {
            return this.raw;
        }
    }

    record VersionData(String versionNumber, String changelog, List<String> gameVersions) {
    }
}

