/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo;

import com.esmods.keepersofthestonestwo.init.PowerModMobEffects;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber
public class SpacePassiveSkills {
    private static final Map<UUID, Long> lastAttackTime = new HashMap<UUID, Long>();
    private static final Map<UUID, Integer> attackStreak = new HashMap<UUID, Integer>();
    private static final int BLINDNESS_DURATION = 100;
    private static final int WEAKNESS_DURATION = 300;

    private static boolean isActiveSpaceMaster(Player player) {
        if (player.level().isClientSide()) {
            return false;
        }
        if (!player.hasEffect(PowerModMobEffects.SPACE_MASTER)) {
            return false;
        }
        Level level = player.level();
        BlockPos pos = player.blockPosition();
        if (level.dimension() == Level.END) {
            return true;
        }
        return level.canSeeSky(pos.above());
    }

    private static boolean isDay(Level level) {
        if (level.dimension() != Level.OVERWORLD) {
            return false;
        }
        long dayTime = level.getDayTime() % 24000L;
        return dayTime >= 0L && dayTime < 13000L;
    }

    private static boolean isNight(Level level) {
        if (level.dimension() != Level.OVERWORLD) {
            return false;
        }
        long dayTime = level.getDayTime() % 24000L;
        return dayTime >= 13000L;
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent.Pre event) {
        boolean outdoors;
        LivingEntity target = event.getEntity();
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        if (target.level().isClientSide()) {
            return;
        }
        if (!SpacePassiveSkills.isActiveSpaceMaster(attacker)) {
            return;
        }
        Level level = attacker.level();
        boolean inEnd = level.dimension() == Level.END;
        boolean bl = outdoors = inEnd || level.canSeeSky(attacker.blockPosition().above());
        if (!outdoors) {
            return;
        }
        UUID uuid = attacker.getUUID();
        long currentTime = level.getGameTime();
        long lastTime = lastAttackTime.getOrDefault(uuid, -100L);
        int streak = attackStreak.getOrDefault(uuid, 0);
        streak = currentTime - lastTime <= 60L ? ++streak : 1;
        lastAttackTime.put(uuid, currentTime);
        attackStreak.put(uuid, streak);
        float originalDamage = event.getOriginalDamage();
        if ((inEnd || level.dimension() == Level.OVERWORLD && SpacePassiveSkills.isDay(level)) && attacker.getRandom().nextFloat() < 0.1f) {
            event.setNewDamage(originalDamage * 2.0f);
            target.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 100, 0, false, true));
            return;
        }
        if ((inEnd || level.dimension() == Level.OVERWORLD && SpacePassiveSkills.isNight(level)) && streak % 3 == 0) {
            event.setNewDamage(originalDamage * 1.25f);
            target.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 300, 2, false, true));
        }
    }
}

