/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo;

import com.esmods.keepersofthestonestwo.init.PowerModMobEffects;
import net.minecraft.core.Holder;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

@EventBusSubscriber
public class SpiritPassiveSkills {
    private static final int BONUS_DURATION = 160;
    private static final int CLEARING_DURATION = 1200;

    private static boolean isActive(Player player) {
        return !player.level().isClientSide() && player.hasEffect(PowerModMobEffects.SPIRIT_MASTER) && player.hasEffect(PowerModMobEffects.PURIFICATION);
    }

    @SubscribeEvent
    public static void onPlayerAttack(LivingDamageEvent.Pre event) {
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        if (!SpiritPassiveSkills.isActive(attacker)) {
            return;
        }
        event.setNewDamage(event.getOriginalDamage() * 1.2f);
    }

    @SubscribeEvent
    public static void onPlayerTakeDamage(LivingDamageEvent.Pre event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!SpiritPassiveSkills.isActive(player)) {
            return;
        }
        if (player.getRandom().nextFloat() < 0.25f) {
            Holder[] effects = new Holder[]{MobEffects.REGENERATION, PowerModMobEffects.STAR_REGENERATION, MobEffects.DAMAGE_BOOST};
            Holder chosen = effects[player.getRandom().nextInt(effects.length)];
            player.addEffect(new MobEffectInstance(chosen, 160, 0, false, true));
        }
    }

    @SubscribeEvent
    public static void onUndeadKill(LivingDeathEvent event) {
        LivingEntity killed = event.getEntity();
        if (killed.level().isClientSide()) {
            return;
        }
        if (!killed.getType().is(EntityTypeTags.UNDEAD)) {
            return;
        }
        Entity source = event.getSource().getEntity();
        if (!(source instanceof Player)) {
            return;
        }
        Player player = (Player)source;
        if (player.hasEffect(PowerModMobEffects.SPIRIT_MASTER)) {
            player.addEffect(new MobEffectInstance(PowerModMobEffects.PURIFICATION, 1200, 0, false, true));
        }
    }
}

