/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo;

import com.esmods.keepersofthestonestwo.init.PowerModMobEffects;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class SunPassiveSkills {
    private static final Map<UUID, Long> lastHealTime = new HashMap<UUID, Long>();

    private static boolean canSunMasterApply(ServerPlayer player) {
        if (!player.hasEffect(PowerModMobEffects.SUN_MASTER)) {
            return false;
        }
        if (!player.level().canSeeSky(player.blockPosition())) {
            return false;
        }
        long time = player.level().getDayTime() % 24000L;
        return time >= 0L && time < 13000L;
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent.Pre event) {
        float maxHealth;
        float health;
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        Entity source = event.getSource().getEntity();
        LivingEntity target = event.getEntity();
        if (!(source instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer attacker = (ServerPlayer)source;
        if (!(target instanceof LivingEntity)) {
            return;
        }
        if (!SunPassiveSkills.canSunMasterApply(attacker)) {
            return;
        }
        if (attacker.level().random.nextFloat() < 0.1f) {
            target.igniteForSeconds(3.0f);
        }
        if ((health = attacker.getHealth()) < (maxHealth = attacker.getMaxHealth()) * 0.75f) {
            float original = event.getOriginalDamage();
            event.setNewDamage(original * 1.2f);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        UUID uuid;
        long lastTime;
        float maxHealth;
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (!SunPassiveSkills.canSunMasterApply(player2)) {
            return;
        }
        float health = player2.getHealth();
        if (health >= (maxHealth = player2.getMaxHealth()) * 0.75f) {
            return;
        }
        FoodData foodData = player2.getFoodData();
        if (foodData.getFoodLevel() < 18 || foodData.getSaturationLevel() <= 0.0f) {
            return;
        }
        long currentTime = player2.level().getGameTime();
        if (currentTime - (lastTime = lastHealTime.getOrDefault(uuid = player2.getUUID(), -100L).longValue()) >= 8L) {
            player2.heal(1.0f);
            lastHealTime.put(uuid, currentTime);
            foodData.setSaturation(Math.max(0.0f, foodData.getSaturationLevel() - 6.0f));
        }
    }
}

