/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo;

import com.esmods.keepersofthestonestwo.init.PowerModMobEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

@EventBusSubscriber
public class TeleportationPassiveSkills {
    private static final int DASH_DURATION = 60;
    private static final int TELEPORT_RADIUS = 4;
    private static final int CONDITION_RADIUS = 4;

    @SubscribeEvent
    public static void onPlayerAttack(LivingDamageEvent.Pre event) {
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        if (attacker.level().isClientSide()) {
            return;
        }
        if (!TeleportationPassiveSkills.isActive(attacker) || !TeleportationPassiveSkills.hasFreeSpace(attacker)) {
            return;
        }
        event.setNewDamage(event.getOriginalDamage() * 1.1f);
        if (attacker.getRandom().nextFloat() < 0.15f) {
            attacker.addEffect(new MobEffectInstance(PowerModMobEffects.DASH, 60, 1, false, false));
        }
    }

    @SubscribeEvent
    public static void onPlayerTakeDamage(LivingIncomingDamageEvent event) {
        BlockPos safePos;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.level().isClientSide()) {
            return;
        }
        if (!TeleportationPassiveSkills.isActive(player) || !TeleportationPassiveSkills.hasFreeSpace(player)) {
            return;
        }
        if (player.getRandom().nextFloat() < 0.1f && (safePos = TeleportationPassiveSkills.findSafeTeleportPosition(player)) != null && player.level() instanceof ServerLevel) {
            event.setCanceled(true);
            player.teleportTo((double)safePos.getX() + 0.5, (double)safePos.getY(), (double)safePos.getZ() + 0.5);
        }
    }

    private static boolean isActive(Player player) {
        return player.hasEffect(PowerModMobEffects.TELEPORTATION_MASTER);
    }

    private static boolean hasFreeSpace(Player player) {
        Level level = player.level();
        BlockPos origin = player.blockPosition();
        RandomSource rand = player.getRandom();
        for (int i = 0; i < 30; ++i) {
            int z;
            int y;
            int x = origin.getX() + rand.nextInt(9) - 4;
            if (!TeleportationPassiveSkills.isSafePosition(level, new BlockPos(x, y = origin.getY() + rand.nextInt(7) - 3, z = origin.getZ() + rand.nextInt(9) - 4))) continue;
            return true;
        }
        return false;
    }

    private static boolean isSafePosition(Level level, BlockPos pos) {
        if (!level.isInWorldBounds(pos)) {
            return false;
        }
        BlockState feet = level.getBlockState(pos);
        BlockState head = level.getBlockState(pos.above());
        BlockState below = level.getBlockState(pos.below());
        if (!feet.isAir() && !feet.canBeReplaced()) {
            return false;
        }
        if (!head.isAir() && !head.canBeReplaced()) {
            return false;
        }
        if (below.isAir() || !below.blocksMotion()) {
            return false;
        }
        return !feet.is(Blocks.LAVA) && !head.is(Blocks.LAVA) && !feet.is(Blocks.FIRE) && !head.is(Blocks.FIRE);
    }

    private static BlockPos findSafeTeleportPosition(Player player) {
        Level level = player.level();
        BlockPos origin = player.blockPosition();
        RandomSource rand = player.getRandom();
        for (int i = 0; i < 60; ++i) {
            double angle = rand.nextDouble() * Math.PI * 2.0;
            double dist = rand.nextDouble() * 4.0;
            int x = origin.getX() + (int)((double)Mth.cos((float)((float)angle)) * dist);
            int z = origin.getZ() + (int)((double)Mth.sin((float)((float)angle)) * dist);
            int y = origin.getY();
            for (int dy = -4; dy <= 4; ++dy) {
                BlockPos candidate = new BlockPos(x, y + dy, z);
                if (!TeleportationPassiveSkills.isSafePosition(level, candidate)) continue;
                return candidate;
            }
        }
        return null;
    }
}

