/*
 * Decompiled with CFR 0.152.
 */
package your.modid.common.event;

import com.esmods.keepersofthestonestwo.init.PowerModMobEffects;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class HeatPassiveSkills {
    private static final int FIRE_DURATION = 3;
    private static final int FIRE_RESIST_DURATION = 1200;
    private static final int REGEN_DURATION = 100;
    private static final int COOLDOWN = 1800;
    private static final Map<UUID, Long> lastActivationTime = new HashMap<UUID, Long>();
    private static final Map<UUID, Boolean> wasBurning = new HashMap<UUID, Boolean>();

    private static boolean isInWarmOrTemperateBiome(Player player) {
        Biome biome = (Biome)player.level().getBiome(player.blockPosition()).value();
        return biome.getModifiedClimateSettings().temperature() >= 0.2f;
    }

    private static boolean isActive(Player player) {
        return !player.level().isClientSide() && player.hasEffect(PowerModMobEffects.HEAT_MASTER) && HeatPassiveSkills.isInWarmOrTemperateBiome(player);
    }

    @SubscribeEvent
    public static void onPlayerAttack(LivingDamageEvent.Pre event) {
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = livingEntity;
        if (!HeatPassiveSkills.isActive(attacker)) {
            return;
        }
        event.setNewDamage(event.getOriginalDamage() * 1.2f);
        if (attacker.getRandom().nextFloat() < 0.1f) {
            target.igniteForSeconds(3.0f);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (!(player instanceof Player)) {
            return;
        }
        Player player2 = player;
        UUID id = player2.getUUID();
        if (!HeatPassiveSkills.isActive(player2)) {
            wasBurning.remove(id);
            lastActivationTime.remove(id);
            return;
        }
        boolean isBurning = player2.isOnFire();
        Boolean wasBurningBefore = wasBurning.get(id);
        if (isBurning && (wasBurningBefore == null || !wasBurningBefore.booleanValue())) {
            long now = player2.level().getGameTime();
            Long last = lastActivationTime.get(id);
            if ((last == null || now - last >= 1800L) && player2.getRandom().nextFloat() < 0.75f) {
                player2.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 1200, 0, false, true));
                player2.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 100, 1, false, true));
                lastActivationTime.put(id, now);
            }
        }
        wasBurning.put(id, isBurning);
    }
}

