/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo.network;

import com.esmods.keepersofthestonestwo.PowerMod;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class PowerModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        PowerMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        PowerMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.ability = message.data.ability;
                    variables.element_name_first = message.data.element_name_first;
                    variables.element_name_second = message.data.element_name_second;
                    variables.element_name_third = message.data.element_name_third;
                    variables.teleporting_effect = message.data.teleporting_effect;
                    variables.fake_element_name_first = message.data.fake_element_name_first;
                    variables.fake_element_name_second = message.data.fake_element_name_second;
                    variables.fake_element_name_third = message.data.fake_element_name_third;
                    variables.abilities_timer = message.data.abilities_timer;
                    variables.fake_element_name_first_timer = message.data.fake_element_name_first_timer;
                    variables.fake_element_name_second_timer = message.data.fake_element_name_second_timer;
                    variables.fake_element_name_third_timer = message.data.fake_element_name_third_timer;
                    variables.power = message.data.power;
                    variables.powerTimer = message.data.powerTimer;
                    variables.mergers = message.data.mergers;
                    variables.power_recovery_multiplier = message.data.power_recovery_multiplier;
                    variables.max_power = message.data.max_power;
                    variables.recharge_timer = message.data.recharge_timer;
                    variables.master_effect_duration = message.data.master_effect_duration;
                    variables.active_power = message.data.active_power;
                    variables.selected = message.data.selected;
                    variables.active_battery = message.data.active_battery;
                    variables.ability_block = message.data.ability_block;
                    variables.use_ability_key_var = message.data.use_ability_key_var;
                    variables.detransf_key_var = message.data.detransf_key_var;
                    variables.wheel_open_key_var = message.data.wheel_open_key_var;
                    variables.second_wheel_open_var = message.data.second_wheel_open_var;
                    variables.third_wheel_open_var = message.data.third_wheel_open_var;
                    variables.first_fake_wheel_open_var = message.data.first_fake_wheel_open_var;
                    variables.second_fake_wheel_open_var = message.data.second_fake_wheel_open_var;
                    variables.third_fake_wheel_open_var = message.data.third_fake_wheel_open_var;
                    variables.ability_using = message.data.ability_using;
                    variables.power_recorded = message.data.power_recorded;
                    variables.debug = message.data.debug;
                    variables.detransform_anim_trigger = message.data.detransform_anim_trigger;
                    variables.helmet = message.data.helmet;
                    variables.chestplate = message.data.chestplate;
                    variables.leggings = message.data.leggings;
                    variables.boots = message.data.boots;
                    variables.unlock_keepers_box = message.data.unlock_keepers_box;
                    variables.transfered_power = message.data.transfered_power;
                    variables.master_effect_end = message.data.master_effect_end;
                    variables.master_effect_start = message.data.master_effect_start;
                    variables.level = message.data.level;
                    variables.level_exp = message.data.level_exp;
                    variables.base_damage_by_lvl = message.data.base_damage_by_lvl;
                    variables.max_level_exp = message.data.max_level_exp;
                    variables.resistance_char = message.data.resistance_char;
                    variables.speed_char = message.data.speed_char;
                    variables.haste_char = message.data.haste_char;
                    variables.jump_char = message.data.jump_char;
                    variables.level_up_status = message.data.level_up_status;
                    variables.rank = message.data.rank;
                    variables.mind_player_owner = message.data.mind_player_owner;
                    variables.mind_used = message.data.mind_used;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public String ability = "0";
        public String element_name_first = "0";
        public String element_name_second = "0";
        public String element_name_third = "0";
        public double teleporting_effect = 0.0;
        public String fake_element_name_first = "0";
        public String fake_element_name_second = "0";
        public String fake_element_name_third = "0";
        public double abilities_timer = 0.0;
        public double fake_element_name_first_timer = 0.0;
        public double fake_element_name_second_timer = 0.0;
        public double fake_element_name_third_timer = 0.0;
        public double power = 0.0;
        public double powerTimer = 0.0;
        public double mergers = 0.0;
        public double power_recovery_multiplier = 1.0;
        public double max_power = 100.0;
        public double recharge_timer = 300.0;
        public double master_effect_duration = 600.0;
        public boolean active_power = false;
        public boolean selected = false;
        public boolean active_battery = false;
        public boolean ability_block = false;
        public boolean use_ability_key_var = false;
        public boolean detransf_key_var = false;
        public boolean wheel_open_key_var = false;
        public boolean second_wheel_open_var = false;
        public boolean third_wheel_open_var = false;
        public boolean first_fake_wheel_open_var = false;
        public boolean second_fake_wheel_open_var = false;
        public boolean third_fake_wheel_open_var = false;
        public boolean ability_using = false;
        public boolean power_recorded = false;
        public boolean debug = false;
        public boolean detransform_anim_trigger = false;
        public ItemStack helmet = ItemStack.f_41583_;
        public ItemStack chestplate = ItemStack.f_41583_;
        public ItemStack leggings = ItemStack.f_41583_;
        public ItemStack boots = ItemStack.f_41583_;
        public boolean unlock_keepers_box = false;
        public boolean transfered_power = false;
        public boolean master_effect_end = false;
        public boolean master_effect_start = false;
        public double level = 1.0;
        public double level_exp = 0.0;
        public double base_damage_by_lvl = 6.0;
        public double max_level_exp = 100.0;
        public double resistance_char = 0.0;
        public double speed_char = 1.0;
        public double haste_char = -1.0;
        public double jump_char = 1.0;
        public boolean level_up_status = false;
        public String rank = "D";
        public String mind_player_owner = "\"\"";
        public boolean mind_used = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PowerMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("ability", this.ability);
            nbt.m_128359_("element_name_first", this.element_name_first);
            nbt.m_128359_("element_name_second", this.element_name_second);
            nbt.m_128359_("element_name_third", this.element_name_third);
            nbt.m_128347_("teleporting_effect", this.teleporting_effect);
            nbt.m_128359_("fake_element_name_first", this.fake_element_name_first);
            nbt.m_128359_("fake_element_name_second", this.fake_element_name_second);
            nbt.m_128359_("fake_element_name_third", this.fake_element_name_third);
            nbt.m_128347_("abilities_timer", this.abilities_timer);
            nbt.m_128347_("fake_element_name_first_timer", this.fake_element_name_first_timer);
            nbt.m_128347_("fake_element_name_second_timer", this.fake_element_name_second_timer);
            nbt.m_128347_("fake_element_name_third_timer", this.fake_element_name_third_timer);
            nbt.m_128347_("power", this.power);
            nbt.m_128347_("powerTimer", this.powerTimer);
            nbt.m_128347_("mergers", this.mergers);
            nbt.m_128347_("power_recovery_multiplier", this.power_recovery_multiplier);
            nbt.m_128347_("max_power", this.max_power);
            nbt.m_128347_("recharge_timer", this.recharge_timer);
            nbt.m_128347_("master_effect_duration", this.master_effect_duration);
            nbt.m_128379_("active_power", this.active_power);
            nbt.m_128379_("selected", this.selected);
            nbt.m_128379_("active_battery", this.active_battery);
            nbt.m_128379_("ability_block", this.ability_block);
            nbt.m_128379_("use_ability_key_var", this.use_ability_key_var);
            nbt.m_128379_("detransf_key_var", this.detransf_key_var);
            nbt.m_128379_("wheel_open_key_var", this.wheel_open_key_var);
            nbt.m_128379_("second_wheel_open_var", this.second_wheel_open_var);
            nbt.m_128379_("third_wheel_open_var", this.third_wheel_open_var);
            nbt.m_128379_("first_fake_wheel_open_var", this.first_fake_wheel_open_var);
            nbt.m_128379_("second_fake_wheel_open_var", this.second_fake_wheel_open_var);
            nbt.m_128379_("third_fake_wheel_open_var", this.third_fake_wheel_open_var);
            nbt.m_128379_("ability_using", this.ability_using);
            nbt.m_128379_("power_recorded", this.power_recorded);
            nbt.m_128379_("debug", this.debug);
            nbt.m_128379_("detransform_anim_trigger", this.detransform_anim_trigger);
            nbt.m_128365_("helmet", (Tag)this.helmet.m_41739_(new CompoundTag()));
            nbt.m_128365_("chestplate", (Tag)this.chestplate.m_41739_(new CompoundTag()));
            nbt.m_128365_("leggings", (Tag)this.leggings.m_41739_(new CompoundTag()));
            nbt.m_128365_("boots", (Tag)this.boots.m_41739_(new CompoundTag()));
            nbt.m_128379_("unlock_keepers_box", this.unlock_keepers_box);
            nbt.m_128379_("transfered_power", this.transfered_power);
            nbt.m_128379_("master_effect_end", this.master_effect_end);
            nbt.m_128379_("master_effect_start", this.master_effect_start);
            nbt.m_128347_("level", this.level);
            nbt.m_128347_("level_exp", this.level_exp);
            nbt.m_128347_("base_damage_by_lvl", this.base_damage_by_lvl);
            nbt.m_128347_("max_level_exp", this.max_level_exp);
            nbt.m_128347_("resistance_char", this.resistance_char);
            nbt.m_128347_("speed_char", this.speed_char);
            nbt.m_128347_("haste_char", this.haste_char);
            nbt.m_128347_("jump_char", this.jump_char);
            nbt.m_128379_("level_up_status", this.level_up_status);
            nbt.m_128359_("rank", this.rank);
            nbt.m_128359_("mind_player_owner", this.mind_player_owner);
            nbt.m_128379_("mind_used", this.mind_used);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.ability = nbt.m_128461_("ability");
            this.element_name_first = nbt.m_128461_("element_name_first");
            this.element_name_second = nbt.m_128461_("element_name_second");
            this.element_name_third = nbt.m_128461_("element_name_third");
            this.teleporting_effect = nbt.m_128459_("teleporting_effect");
            this.fake_element_name_first = nbt.m_128461_("fake_element_name_first");
            this.fake_element_name_second = nbt.m_128461_("fake_element_name_second");
            this.fake_element_name_third = nbt.m_128461_("fake_element_name_third");
            this.abilities_timer = nbt.m_128459_("abilities_timer");
            this.fake_element_name_first_timer = nbt.m_128459_("fake_element_name_first_timer");
            this.fake_element_name_second_timer = nbt.m_128459_("fake_element_name_second_timer");
            this.fake_element_name_third_timer = nbt.m_128459_("fake_element_name_third_timer");
            this.power = nbt.m_128459_("power");
            this.powerTimer = nbt.m_128459_("powerTimer");
            this.mergers = nbt.m_128459_("mergers");
            this.power_recovery_multiplier = nbt.m_128459_("power_recovery_multiplier");
            this.max_power = nbt.m_128459_("max_power");
            this.recharge_timer = nbt.m_128459_("recharge_timer");
            this.master_effect_duration = nbt.m_128459_("master_effect_duration");
            this.active_power = nbt.m_128471_("active_power");
            this.selected = nbt.m_128471_("selected");
            this.active_battery = nbt.m_128471_("active_battery");
            this.ability_block = nbt.m_128471_("ability_block");
            this.use_ability_key_var = nbt.m_128471_("use_ability_key_var");
            this.detransf_key_var = nbt.m_128471_("detransf_key_var");
            this.wheel_open_key_var = nbt.m_128471_("wheel_open_key_var");
            this.second_wheel_open_var = nbt.m_128471_("second_wheel_open_var");
            this.third_wheel_open_var = nbt.m_128471_("third_wheel_open_var");
            this.first_fake_wheel_open_var = nbt.m_128471_("first_fake_wheel_open_var");
            this.second_fake_wheel_open_var = nbt.m_128471_("second_fake_wheel_open_var");
            this.third_fake_wheel_open_var = nbt.m_128471_("third_fake_wheel_open_var");
            this.ability_using = nbt.m_128471_("ability_using");
            this.power_recorded = nbt.m_128471_("power_recorded");
            this.debug = nbt.m_128471_("debug");
            this.detransform_anim_trigger = nbt.m_128471_("detransform_anim_trigger");
            this.helmet = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("helmet"));
            this.chestplate = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("chestplate"));
            this.leggings = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("leggings"));
            this.boots = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("boots"));
            this.unlock_keepers_box = nbt.m_128471_("unlock_keepers_box");
            this.transfered_power = nbt.m_128471_("transfered_power");
            this.master_effect_end = nbt.m_128471_("master_effect_end");
            this.master_effect_start = nbt.m_128471_("master_effect_start");
            this.level = nbt.m_128459_("level");
            this.level_exp = nbt.m_128459_("level_exp");
            this.base_damage_by_lvl = nbt.m_128459_("base_damage_by_lvl");
            this.max_level_exp = nbt.m_128459_("max_level_exp");
            this.resistance_char = nbt.m_128459_("resistance_char");
            this.speed_char = nbt.m_128459_("speed_char");
            this.haste_char = nbt.m_128459_("haste_char");
            this.jump_char = nbt.m_128459_("jump_char");
            this.level_up_status = nbt.m_128471_("level_up_status");
            this.rank = nbt.m_128461_("rank");
            this.mind_player_owner = nbt.m_128461_("mind_player_owner");
            this.mind_used = nbt.m_128471_("mind_used");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("power", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "power_mapvars";
        public double opX = 0.0;
        public double opY = 0.0;
        public double opZ = 0.0;
        public double bpX = 0.0;
        public double bpY = 0.0;
        public double bpZ = 0.0;
        public boolean fire_stone = false;
        public boolean air_stone = false;
        public boolean earth_stone = false;
        public boolean water_stone = false;
        public boolean ether_stone = false;
        public boolean ice_stone = false;
        public boolean lightning_stone = false;
        public boolean sound_stone = false;
        public boolean crystal_stone = false;
        public boolean lava_stone = false;
        public boolean rain_stone = false;
        public boolean tornado_stone = false;
        public boolean ocean_stone = false;
        public boolean plants_stone = false;
        public boolean animals_stone = false;
        public boolean metal_stone = false;
        public boolean light_stone = false;
        public boolean shadow_stone = false;
        public boolean vacuum_stone = false;
        public boolean energy_stone = false;
        public boolean sun_stone = false;
        public boolean moon_stone = false;
        public boolean space_stone = false;
        public boolean time_stone = false;
        public boolean blood_stone = false;
        public boolean technology_stone = false;
        public boolean teleportation_stone = false;
        public boolean explosion_stone = false;
        public boolean amber_stone = false;
        public boolean creation_stone = false;
        public boolean destruction_stone = false;
        public boolean mist_stone = false;
        public boolean sand_stone = false;
        public boolean speed_stone = false;
        public boolean poison_stone = false;
        public boolean magnet_stone = false;
        public boolean mushrooms_stone = false;
        public boolean mercury_stone = false;
        public boolean music_stone = false;
        public boolean plague_stone = false;
        public boolean blue_flame_stone = false;
        public boolean gravity_stone = false;
        public boolean smoke_stone = false;
        public boolean spirit_stone = false;
        public boolean form_stone = false;
        public boolean mind_stone = false;
        public boolean golden_dust_stone = false;
        public boolean darkness_stone = false;
        public boolean blue_portal_placed = false;
        public boolean orange_portal_placed = false;
        public double cpapi_ver = 21.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.opX = nbt.m_128459_("opX");
            this.opY = nbt.m_128459_("opY");
            this.opZ = nbt.m_128459_("opZ");
            this.bpX = nbt.m_128459_("bpX");
            this.bpY = nbt.m_128459_("bpY");
            this.bpZ = nbt.m_128459_("bpZ");
            this.fire_stone = nbt.m_128471_("fire_stone");
            this.air_stone = nbt.m_128471_("air_stone");
            this.earth_stone = nbt.m_128471_("earth_stone");
            this.water_stone = nbt.m_128471_("water_stone");
            this.ether_stone = nbt.m_128471_("ether_stone");
            this.ice_stone = nbt.m_128471_("ice_stone");
            this.lightning_stone = nbt.m_128471_("lightning_stone");
            this.sound_stone = nbt.m_128471_("sound_stone");
            this.crystal_stone = nbt.m_128471_("crystal_stone");
            this.lava_stone = nbt.m_128471_("lava_stone");
            this.rain_stone = nbt.m_128471_("rain_stone");
            this.tornado_stone = nbt.m_128471_("tornado_stone");
            this.ocean_stone = nbt.m_128471_("ocean_stone");
            this.plants_stone = nbt.m_128471_("plants_stone");
            this.animals_stone = nbt.m_128471_("animals_stone");
            this.metal_stone = nbt.m_128471_("metal_stone");
            this.light_stone = nbt.m_128471_("light_stone");
            this.shadow_stone = nbt.m_128471_("shadow_stone");
            this.vacuum_stone = nbt.m_128471_("vacuum_stone");
            this.energy_stone = nbt.m_128471_("energy_stone");
            this.sun_stone = nbt.m_128471_("sun_stone");
            this.moon_stone = nbt.m_128471_("moon_stone");
            this.space_stone = nbt.m_128471_("space_stone");
            this.time_stone = nbt.m_128471_("time_stone");
            this.blood_stone = nbt.m_128471_("blood_stone");
            this.technology_stone = nbt.m_128471_("technology_stone");
            this.teleportation_stone = nbt.m_128471_("teleportation_stone");
            this.explosion_stone = nbt.m_128471_("explosion_stone");
            this.amber_stone = nbt.m_128471_("amber_stone");
            this.creation_stone = nbt.m_128471_("creation_stone");
            this.destruction_stone = nbt.m_128471_("destruction_stone");
            this.mist_stone = nbt.m_128471_("mist_stone");
            this.sand_stone = nbt.m_128471_("sand_stone");
            this.speed_stone = nbt.m_128471_("speed_stone");
            this.poison_stone = nbt.m_128471_("poison_stone");
            this.magnet_stone = nbt.m_128471_("magnet_stone");
            this.mushrooms_stone = nbt.m_128471_("mushrooms_stone");
            this.mercury_stone = nbt.m_128471_("mercury_stone");
            this.music_stone = nbt.m_128471_("music_stone");
            this.plague_stone = nbt.m_128471_("plague_stone");
            this.blue_flame_stone = nbt.m_128471_("blue_flame_stone");
            this.gravity_stone = nbt.m_128471_("gravity_stone");
            this.smoke_stone = nbt.m_128471_("smoke_stone");
            this.spirit_stone = nbt.m_128471_("spirit_stone");
            this.form_stone = nbt.m_128471_("form_stone");
            this.mind_stone = nbt.m_128471_("mind_stone");
            this.golden_dust_stone = nbt.m_128471_("golden_dust_stone");
            this.darkness_stone = nbt.m_128471_("darkness_stone");
            this.blue_portal_placed = nbt.m_128471_("blue_portal_placed");
            this.orange_portal_placed = nbt.m_128471_("orange_portal_placed");
            this.cpapi_ver = nbt.m_128459_("cpapi_ver");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("opX", this.opX);
            nbt.m_128347_("opY", this.opY);
            nbt.m_128347_("opZ", this.opZ);
            nbt.m_128347_("bpX", this.bpX);
            nbt.m_128347_("bpY", this.bpY);
            nbt.m_128347_("bpZ", this.bpZ);
            nbt.m_128379_("fire_stone", this.fire_stone);
            nbt.m_128379_("air_stone", this.air_stone);
            nbt.m_128379_("earth_stone", this.earth_stone);
            nbt.m_128379_("water_stone", this.water_stone);
            nbt.m_128379_("ether_stone", this.ether_stone);
            nbt.m_128379_("ice_stone", this.ice_stone);
            nbt.m_128379_("lightning_stone", this.lightning_stone);
            nbt.m_128379_("sound_stone", this.sound_stone);
            nbt.m_128379_("crystal_stone", this.crystal_stone);
            nbt.m_128379_("lava_stone", this.lava_stone);
            nbt.m_128379_("rain_stone", this.rain_stone);
            nbt.m_128379_("tornado_stone", this.tornado_stone);
            nbt.m_128379_("ocean_stone", this.ocean_stone);
            nbt.m_128379_("plants_stone", this.plants_stone);
            nbt.m_128379_("animals_stone", this.animals_stone);
            nbt.m_128379_("metal_stone", this.metal_stone);
            nbt.m_128379_("light_stone", this.light_stone);
            nbt.m_128379_("shadow_stone", this.shadow_stone);
            nbt.m_128379_("vacuum_stone", this.vacuum_stone);
            nbt.m_128379_("energy_stone", this.energy_stone);
            nbt.m_128379_("sun_stone", this.sun_stone);
            nbt.m_128379_("moon_stone", this.moon_stone);
            nbt.m_128379_("space_stone", this.space_stone);
            nbt.m_128379_("time_stone", this.time_stone);
            nbt.m_128379_("blood_stone", this.blood_stone);
            nbt.m_128379_("technology_stone", this.technology_stone);
            nbt.m_128379_("teleportation_stone", this.teleportation_stone);
            nbt.m_128379_("explosion_stone", this.explosion_stone);
            nbt.m_128379_("amber_stone", this.amber_stone);
            nbt.m_128379_("creation_stone", this.creation_stone);
            nbt.m_128379_("destruction_stone", this.destruction_stone);
            nbt.m_128379_("mist_stone", this.mist_stone);
            nbt.m_128379_("sand_stone", this.sand_stone);
            nbt.m_128379_("speed_stone", this.speed_stone);
            nbt.m_128379_("poison_stone", this.poison_stone);
            nbt.m_128379_("magnet_stone", this.magnet_stone);
            nbt.m_128379_("mushrooms_stone", this.mushrooms_stone);
            nbt.m_128379_("mercury_stone", this.mercury_stone);
            nbt.m_128379_("music_stone", this.music_stone);
            nbt.m_128379_("plague_stone", this.plague_stone);
            nbt.m_128379_("blue_flame_stone", this.blue_flame_stone);
            nbt.m_128379_("gravity_stone", this.gravity_stone);
            nbt.m_128379_("smoke_stone", this.smoke_stone);
            nbt.m_128379_("spirit_stone", this.spirit_stone);
            nbt.m_128379_("form_stone", this.form_stone);
            nbt.m_128379_("mind_stone", this.mind_stone);
            nbt.m_128379_("golden_dust_stone", this.golden_dust_stone);
            nbt.m_128379_("darkness_stone", this.darkness_stone);
            nbt.m_128379_("blue_portal_placed", this.blue_portal_placed);
            nbt.m_128379_("orange_portal_placed", this.orange_portal_placed);
            nbt.m_128347_("cpapi_ver", this.cpapi_ver);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                PowerMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "power_worldvars";
        public double entity_rotation = 0.0;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.entity_rotation = nbt.m_128459_("entity_rotation");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("entity_rotation", this.entity_rotation);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                PowerMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.ability = original.ability;
            clone.element_name_first = original.element_name_first;
            clone.element_name_second = original.element_name_second;
            clone.element_name_third = original.element_name_third;
            clone.fake_element_name_first = original.fake_element_name_first;
            clone.fake_element_name_second = original.fake_element_name_second;
            clone.fake_element_name_third = original.fake_element_name_third;
            clone.max_power = original.max_power;
            clone.recharge_timer = original.recharge_timer;
            clone.master_effect_duration = original.master_effect_duration;
            clone.selected = original.selected;
            clone.active_battery = original.active_battery;
            clone.debug = original.debug;
            clone.helmet = original.helmet;
            clone.chestplate = original.chestplate;
            clone.leggings = original.leggings;
            clone.boots = original.boots;
            clone.unlock_keepers_box = original.unlock_keepers_box;
            clone.level = original.level;
            clone.level_exp = original.level_exp;
            clone.base_damage_by_lvl = original.base_damage_by_lvl;
            clone.max_level_exp = original.max_level_exp;
            clone.resistance_char = original.resistance_char;
            clone.speed_char = original.speed_char;
            clone.haste_char = original.haste_char;
            clone.jump_char = original.jump_char;
            clone.rank = original.rank;
            clone.mind_used = original.mind_used;
            if (!event.isWasDeath()) {
                clone.teleporting_effect = original.teleporting_effect;
                clone.abilities_timer = original.abilities_timer;
                clone.fake_element_name_first_timer = original.fake_element_name_first_timer;
                clone.fake_element_name_second_timer = original.fake_element_name_second_timer;
                clone.fake_element_name_third_timer = original.fake_element_name_third_timer;
                clone.power = original.power;
                clone.powerTimer = original.powerTimer;
                clone.mergers = original.mergers;
                clone.power_recovery_multiplier = original.power_recovery_multiplier;
                clone.active_power = original.active_power;
                clone.ability_block = original.ability_block;
                clone.use_ability_key_var = original.use_ability_key_var;
                clone.detransf_key_var = original.detransf_key_var;
                clone.wheel_open_key_var = original.wheel_open_key_var;
                clone.second_wheel_open_var = original.second_wheel_open_var;
                clone.third_wheel_open_var = original.third_wheel_open_var;
                clone.first_fake_wheel_open_var = original.first_fake_wheel_open_var;
                clone.second_fake_wheel_open_var = original.second_fake_wheel_open_var;
                clone.third_fake_wheel_open_var = original.third_fake_wheel_open_var;
                clone.ability_using = original.ability_using;
                clone.power_recorded = original.power_recorded;
                clone.detransform_anim_trigger = original.detransform_anim_trigger;
                clone.transfered_power = original.transfered_power;
                clone.master_effect_end = original.master_effect_end;
                clone.master_effect_start = original.master_effect_start;
                clone.level_up_status = original.level_up_status;
                clone.mind_player_owner = original.mind_player_owner;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    PowerMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    PowerMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                PowerMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

