/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo;

import com.esmods.keepersofthestonestwo.init.PowerModMobEffects;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

@EventBusSubscriber
public class BlueFlamePassiveSkills {
    private static final int FIRE_DURATION = 100;
    private static final long COMBO_RESET_TIME = 60L;
    private static final int SEARCH_RADIUS = 16;
    private static final int MIN_FIRE_SOURCES = 3;
    private static final Map<UUID, Integer> attackStreak = new HashMap<UUID, Integer>();
    private static final Map<UUID, Long> lastAttackTime = new HashMap<UUID, Long>();

    private static boolean isActive(Player player) {
        if (player.level().isClientSide()) {
            return false;
        }
        if (!player.hasEffect(PowerModMobEffects.BLUE_FLAME_MASTER)) {
            return false;
        }
        Level level = player.level();
        if (level.dimension() == Level.NETHER) {
            return true;
        }
        BlockPos center = player.blockPosition();
        int fireCount = 0;
        for (int x = -16; x <= 16; ++x) {
            for (int y = -16; y <= 16; ++y) {
                for (int z = -16; z <= 16; ++z) {
                    BlockPos pos = center.offset(x, y, z);
                    if (!level.getBlockState(pos).is(Blocks.FIRE) || ++fireCount < 3) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void onPlayerAttack(LivingDamageEvent.Pre event) {
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = livingEntity;
        if (!BlueFlamePassiveSkills.isActive(attacker)) {
            return;
        }
        UUID playerId = attacker.getUUID();
        long currentTime = attacker.level().getGameTime();
        long lastTime = lastAttackTime.getOrDefault(playerId, -100L);
        int streak = attackStreak.getOrDefault(playerId, 0);
        streak = currentTime - lastTime <= 60L ? ++streak : 1;
        lastAttackTime.put(playerId, currentTime);
        attackStreak.put(playerId, streak);
        if (streak % 3 == 0) {
            target.igniteForSeconds(5.0f);
        }
    }

    @SubscribeEvent
    public static void onPlayerTakeFireDamage(LivingIncomingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!BlueFlamePassiveSkills.isActive(player)) {
            return;
        }
        DamageSource source = event.getSource();
        if (source.is(DamageTypes.IN_FIRE) || source.is(DamageTypes.ON_FIRE) || source.is(DamageTypes.LAVA) || source.is(DamageTypes.HOT_FLOOR)) {
            event.setCanceled(true);
        }
    }
}

