/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo;

import com.esmods.keepersofthestonestwo.init.PowerModMobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber
public class MercuryPassiveSkills {
    private static boolean isActive(Player player) {
        return !player.level().isClientSide() && player.hasEffect(PowerModMobEffects.MERCURY_MASTER);
    }

    private static float getBiomeTemperature(Player player) {
        Biome biome = (Biome)player.level().getBiome(player.blockPosition()).value();
        return biome.getModifiedClimateSettings().temperature();
    }

    private static boolean isInColdBiome(Player player) {
        return MercuryPassiveSkills.getBiomeTemperature(player) < 0.2f;
    }

    private static boolean isInWarmBiome(Player player) {
        return MercuryPassiveSkills.getBiomeTemperature(player) > 1.0f;
    }

    @SubscribeEvent
    public static void onPlayerAttack(LivingDamageEvent.Pre event) {
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        if (!MercuryPassiveSkills.isActive(attacker)) {
            return;
        }
        if (!MercuryPassiveSkills.isInColdBiome(attacker)) {
            return;
        }
        event.setNewDamage(event.getOriginalDamage() * 1.25f);
    }

    @SubscribeEvent
    public static void onPlayerTakeDamage(LivingDamageEvent.Pre event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!MercuryPassiveSkills.isActive(player)) {
            return;
        }
        if (!MercuryPassiveSkills.isInWarmBiome(player)) {
            return;
        }
        event.setNewDamage(event.getOriginalDamage() * 0.5f);
    }
}

