/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo;

import com.esmods.keepersofthestonestwo.init.PowerModMobEffects;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class PoisonPassiveSkills {
    private static final int POISON_DURATION = 100;
    private static final int IMMUNITY_COOLDOWN = 600;
    private static final Map<UUID, Long> lastImmunityTime = new HashMap<UUID, Long>();

    private static boolean isActive(Player player) {
        if (player.level().isClientSide()) {
            return false;
        }
        if (!player.hasEffect(PowerModMobEffects.POISON_MASTER)) {
            return false;
        }
        return PoisonPassiveSkills.hasPoisonPotion(player);
    }

    private static boolean hasPoisonPotion(Player player) {
        PotionContents contents;
        for (ItemStack stack : player.getInventory().items) {
            Optional potionOpt;
            PotionContents contents2;
            if (stack.isEmpty() || !stack.is(Items.POTION) || (contents2 = (PotionContents)stack.get(DataComponents.POTION_CONTENTS)) == null || !(potionOpt = contents2.potion()).isPresent() || potionOpt.get() != Potions.POISON) continue;
            return true;
        }
        ItemStack offhand = player.getOffhandItem();
        if (!offhand.isEmpty() && offhand.is(Items.POTION) && (contents = (PotionContents)offhand.get(DataComponents.POTION_CONTENTS)) != null) {
            Optional potionOpt = contents.potion();
            return potionOpt.isPresent() && potionOpt.get() == Potions.POISON;
        }
        return false;
    }

    @SubscribeEvent
    public static void onPlayerAttack(LivingDamageEvent.Pre event) {
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = livingEntity;
        if (!PoisonPassiveSkills.isActive(attacker)) {
            return;
        }
        event.setNewDamage(event.getOriginalDamage() * 1.25f);
        if (attacker.getRandom().nextFloat() < 0.25f) {
            target.addEffect(new MobEffectInstance(MobEffects.POISON, 100, 1, false, true));
        }
    }

    @SubscribeEvent
    public static void onPoisonApplicable(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (!(player instanceof Player)) {
            return;
        }
        Player player2 = player;
        if (!PoisonPassiveSkills.isActive(player2)) {
            return;
        }
        player2.removeEffect(MobEffects.POISON);
    }

    @SubscribeEvent
    public static void onDebuffAdded(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (!(player instanceof Player)) {
            return;
        }
        Player player2 = player;
        if (!PoisonPassiveSkills.isActive(player2)) {
            return;
        }
        UUID playerId = player2.getUUID();
        long currentTime = player2.level().getGameTime();
        Long lastTime = lastImmunityTime.get(playerId);
        if ((lastTime == null || currentTime - lastTime >= 600L) && player2.getRandom().nextFloat() < 0.25f) {
            block0: for (int index0 = 0; index0 < 20; ++index0) {
                for (MobEffectInstance effectInstance : player2.getActiveEffects()) {
                    if (((MobEffect)effectInstance.getEffect().value()).getCategory() != MobEffectCategory.HARMFUL) continue;
                    player2.removeEffect(effectInstance.getEffect());
                    continue block0;
                }
            }
            lastImmunityTime.put(playerId, currentTime);
        }
    }
}

