/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo;

import com.esmods.keepersofthestonestwo.init.PowerModMobEffects;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber
public class VacuumPassiveSkills {
    private static final Map<UUID, Long> lastImmortalityTrigger = new HashMap<UUID, Long>();

    @SubscribeEvent
    public static void onLivingHurt(LivingDamageEvent.Pre event) {
        Player player;
        DamageSource source;
        Level level;
        block9: {
            block8: {
                LivingEntity entity = event.getEntity();
                level = entity.level();
                source = event.getSource();
                if (!(entity instanceof Player)) break block8;
                player = (Player)entity;
                if (!level.isClientSide()) break block9;
            }
            return;
        }
        if (!player.hasEffect(PowerModMobEffects.VACUUM_MASTER)) {
            return;
        }
        if (source.getEntity() == null || !(source.getEntity() instanceof LivingEntity)) {
            return;
        }
        float originalDamage = event.getOriginalDamage();
        float reducedDamage = originalDamage * 0.5f;
        event.setNewDamage(reducedDamage);
        if (player instanceof ServerPlayer) {
            long lastTime;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            long currentTime = level.getGameTime();
            if (lastImmortalityTrigger.containsKey(serverPlayer.getUUID()) && currentTime - (lastTime = lastImmortalityTrigger.get(serverPlayer.getUUID()).longValue()) < 3600L) {
                return;
            }
            if (level.random.nextFloat() < 0.15f) {
                serverPlayer.addEffect(new MobEffectInstance(PowerModMobEffects.IMMORTALITY, 400, 0, false, true, true));
                lastImmortalityTrigger.put(serverPlayer.getUUID(), currentTime);
            }
        }
    }
}

