/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo.entity;

import com.esmods.keepersofthestonestwo.init.PowerModItems;
import com.esmods.keepersofthestonestwo.procedures.CursedKeeperAggroProcedure;
import com.esmods.keepersofthestonestwo.procedures.CursedKeeperAttack1Procedure;
import com.esmods.keepersofthestonestwo.procedures.CursedKeeperAttack2Procedure;
import com.esmods.keepersofthestonestwo.procedures.CursedKeeperAttack3Procedure;
import com.esmods.keepersofthestonestwo.procedures.CursedKeeperAttack4Procedure;
import com.esmods.keepersofthestonestwo.procedures.CursedKeeperAttack5Procedure;
import com.esmods.keepersofthestonestwo.procedures.CursedKeeperFallProcedure;
import com.esmods.keepersofthestonestwo.procedures.CursedKeeperIdle0Procedure;
import com.esmods.keepersofthestonestwo.procedures.CursedKeeperIdle1Procedure;
import com.esmods.keepersofthestonestwo.procedures.CursedKeeperIdle2Procedure;
import com.esmods.keepersofthestonestwo.procedures.CursedKeeperPriGibieliSushchnostiProcedure;
import com.esmods.keepersofthestonestwo.procedures.CursedKeeperPriObnovlieniiTikaSushchnostiProcedure;
import com.esmods.keepersofthestonestwo.procedures.CursedKeeperSprintingProcedure;
import com.esmods.keepersofthestonestwo.procedures.CursedKeeperWalkProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class CursedKeeperEntity
extends Monster {
    public static final EntityDataAccessor<Integer> DATA_attack_anim_sync = SynchedEntityData.defineId(CursedKeeperEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_stage_zero_anim_sync = SynchedEntityData.defineId(CursedKeeperEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_stage_one_anim_sync = SynchedEntityData.defineId(CursedKeeperEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_stage_two_anim_sync = SynchedEntityData.defineId(CursedKeeperEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_aggro_anim_sync = SynchedEntityData.defineId(CursedKeeperEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_fall_anim_sync = SynchedEntityData.defineId(CursedKeeperEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_IA = SynchedEntityData.defineId(CursedKeeperEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<String> DATA_State = SynchedEntityData.defineId(CursedKeeperEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Boolean> DATA_Phase = SynchedEntityData.defineId(CursedKeeperEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_Wave = SynchedEntityData.defineId(CursedKeeperEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_Patience = SynchedEntityData.defineId(CursedKeeperEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_OnBattle = SynchedEntityData.defineId(CursedKeeperEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_Look = SynchedEntityData.defineId(CursedKeeperEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_windShield = SynchedEntityData.defineId(CursedKeeperEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_BreathRange = SynchedEntityData.defineId(CursedKeeperEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();
    public final AnimationState animationState4 = new AnimationState();
    public final AnimationState animationState5 = new AnimationState();
    public final AnimationState animationState6 = new AnimationState();
    public final AnimationState animationState7 = new AnimationState();
    public final AnimationState animationState8 = new AnimationState();
    public final AnimationState animationState9 = new AnimationState();
    public final AnimationState animationState10 = new AnimationState();
    public final AnimationState animationState11 = new AnimationState();
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.NOTCHED_10);

    public CursedKeeperEntity(EntityType<CursedKeeperEntity> type, Level world) {
        super(type, world);
        this.xpReward = 1000;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_attack_anim_sync, (Object)0);
        builder.define(DATA_stage_zero_anim_sync, (Object)true);
        builder.define(DATA_stage_one_anim_sync, (Object)false);
        builder.define(DATA_stage_two_anim_sync, (Object)false);
        builder.define(DATA_aggro_anim_sync, (Object)false);
        builder.define(DATA_fall_anim_sync, (Object)false);
        builder.define(DATA_IA, (Object)0);
        builder.define(DATA_State, (Object)"");
        builder.define(DATA_Phase, (Object)false);
        builder.define(DATA_Wave, (Object)0);
        builder.define(DATA_Patience, (Object)0);
        builder.define(DATA_OnBattle, (Object)false);
        builder.define(DATA_Look, (Object)0);
        builder.define(DATA_windShield, (Object)0);
        builder.define(DATA_BreathRange, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.2, true){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new FloatGoal((Mob)this));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource source, boolean recentlyHitIn) {
        super.dropCustomDeathLoot(serverLevel, source, recentlyHitIn);
        this.spawnAtLocation(new ItemStack((ItemLike)PowerModItems.LUCK_COIN.get()));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.death"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.IN_FIRE)) {
            return false;
        }
        if (damagesource.getDirectEntity() instanceof AbstractArrow) {
            return false;
        }
        if (damagesource.getDirectEntity() instanceof ThrownPotion || damagesource.getDirectEntity() instanceof AreaEffectCloud || damagesource.typeHolder().is(NeoForgeMod.POISON_DAMAGE)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.CACTUS)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        if (damagesource.is(DamageTypes.LIGHTNING_BOLT)) {
            return false;
        }
        if (damagesource.is(DamageTypes.EXPLOSION) || damagesource.is(DamageTypes.PLAYER_EXPLOSION)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALLING_ANVIL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DRAGON_BREATH)) {
            return false;
        }
        if (damagesource.is(DamageTypes.WITHER) || damagesource.is(DamageTypes.WITHER_SKULL)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public void die(DamageSource source) {
        super.die(source);
        CursedKeeperPriGibieliSushchnostiProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ());
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Dataattack_anim_sync", ((Integer)this.entityData.get(DATA_attack_anim_sync)).intValue());
        compound.putBoolean("Datastage_zero_anim_sync", ((Boolean)this.entityData.get(DATA_stage_zero_anim_sync)).booleanValue());
        compound.putBoolean("Datastage_one_anim_sync", ((Boolean)this.entityData.get(DATA_stage_one_anim_sync)).booleanValue());
        compound.putBoolean("Datastage_two_anim_sync", ((Boolean)this.entityData.get(DATA_stage_two_anim_sync)).booleanValue());
        compound.putBoolean("Dataaggro_anim_sync", ((Boolean)this.entityData.get(DATA_aggro_anim_sync)).booleanValue());
        compound.putBoolean("Datafall_anim_sync", ((Boolean)this.entityData.get(DATA_fall_anim_sync)).booleanValue());
        compound.putInt("DataIA", ((Integer)this.entityData.get(DATA_IA)).intValue());
        compound.putString("DataState", (String)this.entityData.get(DATA_State));
        compound.putBoolean("DataPhase", ((Boolean)this.entityData.get(DATA_Phase)).booleanValue());
        compound.putInt("DataWave", ((Integer)this.entityData.get(DATA_Wave)).intValue());
        compound.putInt("DataPatience", ((Integer)this.entityData.get(DATA_Patience)).intValue());
        compound.putBoolean("DataOnBattle", ((Boolean)this.entityData.get(DATA_OnBattle)).booleanValue());
        compound.putInt("DataLook", ((Integer)this.entityData.get(DATA_Look)).intValue());
        compound.putInt("DatawindShield", ((Integer)this.entityData.get(DATA_windShield)).intValue());
        compound.putInt("DataBreathRange", ((Integer)this.entityData.get(DATA_BreathRange)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Dataattack_anim_sync")) {
            this.entityData.set(DATA_attack_anim_sync, (Object)compound.getInt("Dataattack_anim_sync"));
        }
        if (compound.contains("Datastage_zero_anim_sync")) {
            this.entityData.set(DATA_stage_zero_anim_sync, (Object)compound.getBoolean("Datastage_zero_anim_sync"));
        }
        if (compound.contains("Datastage_one_anim_sync")) {
            this.entityData.set(DATA_stage_one_anim_sync, (Object)compound.getBoolean("Datastage_one_anim_sync"));
        }
        if (compound.contains("Datastage_two_anim_sync")) {
            this.entityData.set(DATA_stage_two_anim_sync, (Object)compound.getBoolean("Datastage_two_anim_sync"));
        }
        if (compound.contains("Dataaggro_anim_sync")) {
            this.entityData.set(DATA_aggro_anim_sync, (Object)compound.getBoolean("Dataaggro_anim_sync"));
        }
        if (compound.contains("Datafall_anim_sync")) {
            this.entityData.set(DATA_fall_anim_sync, (Object)compound.getBoolean("Datafall_anim_sync"));
        }
        if (compound.contains("DataIA")) {
            this.entityData.set(DATA_IA, (Object)compound.getInt("DataIA"));
        }
        if (compound.contains("DataState")) {
            this.entityData.set(DATA_State, (Object)compound.getString("DataState"));
        }
        if (compound.contains("DataPhase")) {
            this.entityData.set(DATA_Phase, (Object)compound.getBoolean("DataPhase"));
        }
        if (compound.contains("DataWave")) {
            this.entityData.set(DATA_Wave, (Object)compound.getInt("DataWave"));
        }
        if (compound.contains("DataPatience")) {
            this.entityData.set(DATA_Patience, (Object)compound.getInt("DataPatience"));
        }
        if (compound.contains("DataOnBattle")) {
            this.entityData.set(DATA_OnBattle, (Object)compound.getBoolean("DataOnBattle"));
        }
        if (compound.contains("DataLook")) {
            this.entityData.set(DATA_Look, (Object)compound.getInt("DataLook"));
        }
        if (compound.contains("DatawindShield")) {
            this.entityData.set(DATA_windShield, (Object)compound.getInt("DatawindShield"));
        }
        if (compound.contains("DataBreathRange")) {
            this.entityData.set(DATA_BreathRange, (Object)compound.getInt("DataBreathRange"));
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(CursedKeeperSprintingProcedure.execute((Entity)this), this.tickCount);
            this.animationState1.animateWhen(CursedKeeperWalkProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(CursedKeeperIdle0Procedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(CursedKeeperIdle1Procedure.execute((Entity)this), this.tickCount);
            this.animationState4.animateWhen(CursedKeeperIdle2Procedure.execute((Entity)this), this.tickCount);
            this.animationState5.animateWhen(CursedKeeperAggroProcedure.execute((Entity)this), this.tickCount);
            this.animationState6.animateWhen(CursedKeeperFallProcedure.execute((Entity)this), this.tickCount);
            this.animationState7.animateWhen(CursedKeeperAttack1Procedure.execute((Entity)this), this.tickCount);
            this.animationState8.animateWhen(CursedKeeperAttack2Procedure.execute((Entity)this), this.tickCount);
            this.animationState9.animateWhen(CursedKeeperAttack3Procedure.execute((Entity)this), this.tickCount);
            this.animationState10.animateWhen(CursedKeeperAttack4Procedure.execute((Entity)this), this.tickCount);
            this.animationState11.animateWhen(CursedKeeperAttack5Procedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        CursedKeeperPriObnovlieniiTikaSushchnostiProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossInfo.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    public void customServerAiStep() {
        super.customServerAiStep();
        this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.25);
        builder = builder.add(Attributes.MAX_HEALTH, 700.0);
        builder = builder.add(Attributes.ARMOR, 10.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 100.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 128.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 0.25);
        return builder;
    }
}

