/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo.procedures;

import com.esmods.keepersofthestonestwo.PowerMod;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationFactory;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(modid="power", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class AnimationsModuleSetupProcedure {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        PlayerAnimationFactory.ANIMATION_DATA_FACTORY.registerFactory(new ResourceLocation("power", "player_animation"), 1000, AnimationsModuleSetupProcedure::registerPlayerAnimations);
    }

    private static IAnimation registerPlayerAnimations(AbstractClientPlayer player) {
        return new ModifierLayer();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setAnimationClientside(Player player, String anim, boolean override) {
        AbstractClientPlayer player_;
        ModifierLayer animation;
        if (player instanceof AbstractClientPlayer && ((animation = (ModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)(player_ = (AbstractClientPlayer)player)).get(new ResourceLocation("power", "player_animation"))) != null && override || !animation.isActive())) {
            animation.setAnimation((IAnimation)new KeyframeAnimationPlayer(PlayerAnimationRegistry.getAnimation((ResourceLocation)new ResourceLocation("power", anim))));
        }
    }

    public static void execute() {
        AnimationsModuleSetupProcedure.execute(null);
    }

    private static void execute(@Nullable Event event) {
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class PowerModAnimationMessage {
        Component animation;
        int target;
        boolean override;

        public PowerModAnimationMessage(Component animation, int target, boolean override) {
            this.animation = animation;
            this.target = target;
            this.override = override;
        }

        public PowerModAnimationMessage(FriendlyByteBuf buffer) {
            this.animation = buffer.m_130238_();
            this.target = buffer.readInt();
            this.override = buffer.readBoolean();
        }

        public static void buffer(PowerModAnimationMessage message, FriendlyByteBuf buffer) {
            buffer.m_130083_(message.animation);
            buffer.writeInt(message.target);
            buffer.writeBoolean(message.override);
        }

        public static void handler(PowerModAnimationMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                Level level = context.getSender().m_9236_();
                if (level.m_6815_(message.target) != null) {
                    Player player = (Player)level.m_6815_(message.target);
                    AnimationsModuleSetupProcedure.setAnimationClientside(player, message.animation.getString(), message.override);
                }
            });
            context.setPacketHandled(true);
        }

        @SubscribeEvent
        public static void registerMessage(FMLCommonSetupEvent event) {
            PowerMod.addNetworkMessage(PowerModAnimationMessage.class, PowerModAnimationMessage::buffer, PowerModAnimationMessage::new, PowerModAnimationMessage::handler);
        }
    }
}

