package com.github.argon4w.acceleratedrendering.compat.iris.programs.processing;

import com.github.argon4w.acceleratedrendering.compat.iris.IrisCompatFeature;
import com.github.argon4w.acceleratedrendering.core.programs.dispatchers.FixedPolygonProgramDispatcher;
import com.github.argon4w.acceleratedrendering.core.programs.dispatchers.IPolygonProgramDispatcher;
import com.github.argon4w.acceleratedrendering.core.programs.processing.IPolygonProcessor;
import net.minecraft.class_293;
import net.minecraft.class_2960;

public class IrisPolygonProcessor implements IPolygonProcessor {

	private final IPolygonProcessor			parent;
	private final IPolygonProgramDispatcher	quadDispatcher;
	private final IPolygonProgramDispatcher	triangleDispatcher;

	public IrisPolygonProcessor(
			IPolygonProcessor	parent,
			class_2960	quadProgramKey,
			class_2960	triangleProgramKey
	) {
		this.parent				= parent;
		this.quadDispatcher		= new FixedPolygonProgramDispatcher	(class_293.class_5596.field_27382,		quadProgramKey);
		this.triangleDispatcher	= new FixedPolygonProgramDispatcher	(class_293.class_5596.field_27379,	triangleProgramKey);
	}

	@Override
	public IPolygonProgramDispatcher select(class_293.class_5596 mode) {
		if (		IrisCompatFeature	.isEnabled					()
				&&	IrisCompatFeature	.isPolygonProcessingEnabled	()
		) {
			return switch (mode) {
				case field_27382		-> quadDispatcher;
				case field_27379	-> triangleDispatcher;
				default			-> parent.select(mode);
			};
		}

		return parent.select(mode);
	}
}
