package com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders;

import com.github.argon4w.acceleratedrendering.core.meshes.ServerMesh;
import lombok.AllArgsConstructor;
import lombok.EqualsAndHashCode;
import lombok.experimental.ExtensionMethod;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import java.nio.ByteBuffer;


@AllArgsConstructor
@EqualsAndHashCode	(callSuper = false)
@ExtensionMethod	(VertexConsumerExtension.class)
public class AcceleratedEntityOutlineGenerator extends AcceleratedVertexConsumerWrapper {

	private final class_4588	delegate;
	private final int				color;

	@Override
	public class_4588 getDelegate() {
		return delegate;
	}

	@Override
	public class_4588 decorate(class_4588 buffer) {
		return new AcceleratedEntityOutlineGenerator(
				getDelegate				()
						.getAccelerated	()
						.decorate		(buffer),
				color
		);
	}

	@Override
	public void addClientMesh(
			ByteBuffer meshBuffer,
			int			size,
			int			color,
			int			light,
			int			overlay
	) {
		getDelegate				()
				.getAccelerated	()
				.addClientMesh	(
						meshBuffer,
						size,
						this.color,
						light,
						overlay
				);
	}

	@Override
	public void addServerMesh(
			ServerMesh serverMesh,
			int			color,
			int			light,
			int			overlay
	) {
		getDelegate				()
				.getAccelerated	()
				.addServerMesh	(
						serverMesh,
						this.color,
						light,
						overlay
				);
	}

	@Override
	public class_4588 method_22912(
			float pX,
			float pY,
			float pZ
	) {
		delegate.method_22912(
				pX,
				pY,
				pZ
		).method_39415(color);
		return this;
	}

	@Override
	public class_4588 method_56824(
			class_4587.class_4665	pPose,
			float			pX,
			float			pY,
			float			pZ
	) {
		delegate.method_56824(
				pPose,
				pX,
				pY,
				pZ
		).method_39415(color);
		return this;
	}

	@Override
	public class_4588 method_1336(
			int pRed,
			int pGreen,
			int pBlue,
			int pAlpha
	) {
		return this;
	}

	@Override
	public class_4588 method_60796(int pU, int pV) {
		return this;
	}

	@Override
	public class_4588 method_22921(int pU, int pV) {
		return this;
	}

	@Override
	public class_4588 method_22914(
			float pNormalX,
			float pNormalY,
			float pNormalZ
	) {
		return this;
	}

	@Override
	public class_4588 method_60831(
			class_4587.class_4665	pPose,
			float			pNormalX,
			float			pNormalY,
			float			pNormalZ
	) {
		return this;
	}

	@Override
	public void method_23919(
			float	x,
			float	y,
			float	z,
			int		color,
			float	u,
			float	v,
			int		packedOverlay,
			int		packedLight,
			float	normalX,
			float	normalY,
			float	normalZ
	) {
		getDelegate().method_23919(
				x,
				y,
				z,
				this.color,
				u,
				v,
				packedOverlay,
				packedLight,
				normalX,
				normalY,
				normalZ
		);
	}
}
