package com.github.argon4w.acceleratedrendering.core.meshes.collectors;

import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryInterface;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryLayout;
import net.minecraft.class_296;
import net.minecraft.class_4588;
import net.minecraft.class_5253;
import net.minecraft.class_9799;

public class SimpleMeshCollector implements class_4588, IMeshCollector {

	private final	IMemoryLayout<class_296>	layout;
	private final	class_9799					buffer;

	private final	long								vertexSize;
	private final	IMemoryInterface					posOffset;
	private final	IMemoryInterface					colorOffset;
	private final	IMemoryInterface					uv0Offset;
	private final	IMemoryInterface					uv2Offset;
	private final	IMemoryInterface					normalOffset;

	private			long								vertexAddress;
	private			int									vertexCount;

	public SimpleMeshCollector(IMemoryLayout<class_296> layout) {
		this.layout			= layout;
		this.buffer			= new class_9799		(1024);

		this.vertexSize		= this.layout	.getSize	();
		this.posOffset		= this.layout	.getElement	(class_296.field_52107);
		this.colorOffset	= this.layout	.getElement	(class_296.field_52108);
		this.uv0Offset		= this.layout	.getElement	(class_296.field_52110);
		this.uv2Offset		= this.layout	.getElement	(class_296.field_52112);
		this.normalOffset	= this.layout	.getElement	(class_296.field_52113);

		this.vertexAddress	= -1L;
		this.vertexCount	= 0;
	}

	@Override
	public class_4588 method_22912(
			float pX,
			float pY,
			float pZ
	) {
		vertexCount ++;
		vertexAddress = buffer.method_60808((int) vertexSize);

		posOffset.putFloat(vertexAddress + 0L, pX);
		posOffset.putFloat(vertexAddress + 4L, pY);
		posOffset.putFloat(vertexAddress + 8L, pZ);

		return this;
	}

	@Override
	public class_4588 method_1336(
			int pRed,
			int pGreen,
			int pBlue,
			int pAlpha
	) {
		if (vertexAddress == -1) {
			throw new IllegalStateException("Vertex not building!");
		}

		colorOffset.putByte(vertexAddress + 0L, (byte) pRed);
		colorOffset.putByte(vertexAddress + 1L, (byte) pGreen);
		colorOffset.putByte(vertexAddress + 2L, (byte) pBlue);
		colorOffset.putByte(vertexAddress + 3L, (byte) pAlpha);

		return this;
	}

	@Override
	public class_4588 method_22913(float pU, float pV) {
		if (vertexAddress == -1) {
			throw new IllegalStateException("Vertex not building!");
		}

		uv0Offset.putFloat(vertexAddress + 0L, pU);
		uv0Offset.putFloat(vertexAddress + 4L, pV);

		return this;
	}

	@Override
	public class_4588 method_60796(int pU, int pV) {
		return this;
	}

	@Override
	public class_4588 method_22921(int pU, int pV) {
		if (vertexAddress == -1) {
			throw new IllegalStateException("Vertex not building!");
		}

		uv2Offset.putShort(vertexAddress + 0L, (short) pU);
		uv2Offset.putShort(vertexAddress + 2L, (short) pV);

		return this;
	}

	@Override
	public class_4588 method_22914(
			float pNormalX,
			float pNormalY,
			float pNormalZ
	) {
		if (vertexAddress == -1) {
			throw new IllegalStateException("Vertex not building!");
		}

		normalOffset.putNormal(vertexAddress + 0L, pNormalX);
		normalOffset.putNormal(vertexAddress + 1L, pNormalY);
		normalOffset.putNormal(vertexAddress + 2L, pNormalZ);

		return this;
	}

	@Override
	public void method_23919(
			float	pX,
			float	pY,
			float	pZ,
			int		pColor,
			float	pU,
			float	pV,
			int		pPackedOverlay,
			int		pPackedLight,
			float	pNormalX,
			float	pNormalY,
			float	pNormalZ
	) {
		vertexCount++;
		vertexAddress = buffer.method_60808((int) vertexSize);

		posOffset	.putFloat	(vertexAddress + 0L,	pX);
		posOffset	.putFloat	(vertexAddress + 4L,	pY);
		posOffset	.putFloat	(vertexAddress + 8L,	pZ);
		colorOffset	.putInt		(vertexAddress,			class_5253.class_8045.method_60675(pColor));
		uv0Offset	.putFloat	(vertexAddress + 0L,	pU);
		uv0Offset	.putFloat	(vertexAddress + 4L,	pV);
		uv2Offset	.putInt		(vertexAddress,			pPackedLight);
		normalOffset.putNormal	(vertexAddress + 0L,	pNormalX);
		normalOffset.putNormal	(vertexAddress + 1L,	pNormalY);
		normalOffset.putNormal	(vertexAddress + 2L,	pNormalZ);
	}

	@Override
	public class_9799 getBuffer() {
		return buffer;
	}

	@Override
	public IMemoryLayout<class_296> getLayout() {
		return layout;
	}

	@Override
	public int getVertexCount() {
		return vertexCount;
	}
}
