package com.github.argon4w.acceleratedrendering.core.mixins;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.VertexConsumerExtension;
import com.github.argon4w.acceleratedrendering.core.programs.ComputeShaderProgramLoader;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import lombok.experimental.ExtensionMethod;
import net.minecraft.class_1921;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@ExtensionMethod(VertexConsumerExtension		.class)
@Mixin			(class_4597.class_4598	.class)
public class BufferSourceMixin {

	@ModifyReturnValue(
			method	= "getBuffer",
			at		= @At("RETURN")
	)
	public class_4588 initAcceleration(class_4588 original, class_1921 renderType) {
		if (ComputeShaderProgramLoader.isProgramsLoaded()) {
			return original
				.getHolder()
				.initAcceleration(renderType);
		}
		return original;
	}
}
