package com.github.argon4w.acceleratedrendering.core.mixins;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.VertexConsumerExtension;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.renderers.IAcceleratedRenderer;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.renderers.SheetedDecalTextureRenderer;
import lombok.experimental.ExtensionMethod;
import net.minecraft.class_4583;
import net.minecraft.class_4588;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@ExtensionMethod(VertexConsumerExtension		.class)
@Mixin			(class_4583	.class)
public class SheetedDecalTextureGeneratorMixin implements IAcceleratedVertexConsumer {

	@Shadow @Final private class_4588	delegate;
	@Shadow @Final private Matrix4f			cameraInversePose;
	@Shadow @Final private Matrix3f			normalInversePose;
	@Shadow @Final private float			textureScale;

	@Unique
	@Override
	public boolean isAccelerated() {
		return delegate
				.getAccelerated()
				.isAccelerated();
	}

	@Unique
	@Override
	public <T>  void doRender(
			IAcceleratedRenderer<T>	renderer,
			T						context,
			Matrix4f				transform,
			Matrix3f				normal,
			int						light,
			int						overlay,
			int						color
	) {
		delegate
				.getAccelerated	()
				.doRender		(
						new SheetedDecalTextureRenderer<>(
								renderer,
								cameraInversePose,
								normalInversePose,
								textureScale
						),
						context,
						transform,
						normal,
						light,
						overlay,
						color
				);
	}
}
