package com.github.argon4w.acceleratedrendering.core.programs;

import com.github.argon4w.acceleratedrendering.core.backends.programs.BarrierFlags;
import com.google.common.collect.ImmutableMap;
import net.minecraft.class_2960;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.event.IModBusEvent;

import java.util.Map;

public class LoadComputeShaderEvent extends Event implements IModBusEvent {

	private final ImmutableMap.Builder<class_2960, ComputeShaderDefinition> shaderLocations;

	public LoadComputeShaderEvent() {
		this.shaderLocations = ImmutableMap.builder();
	}

	public void loadComputeShader(
			class_2960	key,
			class_2960	location,
			BarrierFlags...		barrierFlags
	) {
		shaderLocations.put(key, new ComputeShaderDefinition(location, BarrierFlags.getFlags(barrierFlags)));
	}

	public Map<class_2960, ComputeShaderDefinition> build() {
		return shaderLocations.build();
	}
}
