package com.github.argon4w.acceleratedrendering.core.programs.culling;

import lombok.Getter;
import net.minecraft.class_293;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.event.IModBusEvent;

import java.util.function.UnaryOperator;

public class LoadCullingProgramSelectorEvent extends Event implements IModBusEvent {

	private final	class_293			vertexFormat;

	@Getter private ICullingProgramSelector	selector;

	public LoadCullingProgramSelectorEvent(class_293 vertexFormat) {
		this.vertexFormat	= vertexFormat;
		this.selector		= PassThroughCullingProgramSelector.INSTANCE;
	}

	public void loadFor(class_293 vertexFormat, UnaryOperator<ICullingProgramSelector> selector) {
		if (this.vertexFormat == vertexFormat) {
			this.selector = selector.apply(this.selector);
		}
	}
}
