package com.github.argon4w.acceleratedrendering.core.programs.culling;

import com.github.argon4w.acceleratedrendering.core.backends.programs.ComputeProgram;
import com.github.argon4w.acceleratedrendering.core.backends.programs.Uniform;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.AcceleratedBufferBuilder;
import com.github.argon4w.acceleratedrendering.core.programs.ComputeShaderProgramLoader;
import com.github.argon4w.acceleratedrendering.core.programs.ComputeShaderPrograms;
import net.minecraft.class_293;
import net.minecraft.class_2960;

public class PassThroughCullingProgramDispatcher implements ICullingProgramDispatcher {

	public	static	final		PassThroughCullingProgramDispatcher	QUAD				= new PassThroughCullingProgramDispatcher(class_293.class_5596.field_27382,		ComputeShaderPrograms.CORE_PASS_THROUGH_QUAD_CULLING_KEY);
	public	static	final		PassThroughCullingProgramDispatcher	TRIANGLE			= new PassThroughCullingProgramDispatcher(class_293.class_5596.field_27379,	ComputeShaderPrograms.CORE_PASS_THROUGH_TRIANGLE_CULLING_KEY);
	private static	final		int									GROUP_SIZE			= 128;
	private static	final		int									DISPATCH_COUNT_Y_Z	= 1;

	private final class_293.class_5596	mode;
	private final ComputeProgram	program;
	private final Uniform			polygonCountUniform;
	private final Uniform			vertexOffsetUniform;

	public PassThroughCullingProgramDispatcher(class_293.class_5596 mode, class_2960 key) {
		this.mode					= mode;
		this.program				= ComputeShaderProgramLoader.getProgram(key);
		this.polygonCountUniform	= program					.getUniform("polygonCount");
		this.vertexOffsetUniform	= program					.getUniform("vertexOffset");
	}

	@Override
	public int dispatch(AcceleratedBufferBuilder builder) {
		var vertexCount		= builder			.getTotalVertexCount();
		var polygonCount	= vertexCount / mode.field_27384;

		polygonCountUniform.uploadUnsignedInt(polygonCount);
		vertexOffsetUniform.uploadUnsignedInt((int) (builder.getVertexBuffer().getOffset() / builder.getVertexSize()));

		program.useProgram	();
		program.dispatch	(
				(polygonCount + GROUP_SIZE - 1) / GROUP_SIZE,
				DISPATCH_COUNT_Y_Z,
				DISPATCH_COUNT_Y_Z
		);

		return program.getBarrierFlags();
	}

	@Override
	public boolean shouldCull() {
		return false;
	}
}
