package com.github.argon4w.acceleratedrendering.core.utils;

import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import net.minecraft.class_1011;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import org.lwjgl.system.MemoryStack;

import static org.lwjgl.opengl.GL46.*;


public class TextureUtils implements class_4013 {

	public 	static	final TextureUtils													INSTANCE	= new TextureUtils						();
	private	static	final Object2ObjectLinkedOpenHashMap<class_2960, class_1011> IMAGE_CACHE	= new Object2ObjectLinkedOpenHashMap<>	();

	@Override
	public void method_14491(class_3300 resourceManager) {
		IMAGE_CACHE.clear();
	}

	public static class_1011 downloadTexture(class_1921 renderType, int mipmapLevel) {
		var textureResourceLocation = RenderTypeUtils.getTextureLocation(renderType);

		if (textureResourceLocation == null) {
			return null;
		}

		var image = IMAGE_CACHE.getAndMoveToFirst(textureResourceLocation);

		if (image != null) {
			return image;
		}

		class_310
				.method_1551		()
				.method_1531	()
				.method_4619			(textureResourceLocation)
				.method_23207				();

		try (var stack = MemoryStack.stackPush()) {
			var widthBuffer		= stack.callocInt(1);
			var heightBuffer	= stack.callocInt(1);

			glGetTexLevelParameteriv(
					GL_TEXTURE_2D,
					mipmapLevel,
					GL_TEXTURE_WIDTH,
					widthBuffer
			);

			glGetTexLevelParameteriv(
					GL_TEXTURE_2D,
					mipmapLevel,
					GL_TEXTURE_HEIGHT,
					heightBuffer
			);

			var width	= widthBuffer	.get(0);
			var height	= heightBuffer	.get(0);

			if (width == 0 || height == 0) {
				return null;
			}

			var nativeImage = new class_1011(
					width,
					height,
					false
			);

			nativeImage	.method_4327	(mipmapLevel,				false);
			IMAGE_CACHE	.putAndMoveToFirst	(textureResourceLocation,	nativeImage);

			if (IMAGE_CACHE.size() > CoreFeature.getCachedImageSize()) {
				IMAGE_CACHE
						.removeLast	()
						.close		();
			}

			return nativeImage;
		}
	}
}
