package com.github.argon4w.acceleratedrendering.features.culling;

import com.github.argon4w.acceleratedrendering.core.backends.programs.ComputeProgram;
import com.github.argon4w.acceleratedrendering.core.backends.programs.Uniform;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.AcceleratedBufferBuilder;
import com.github.argon4w.acceleratedrendering.core.programs.ComputeShaderProgramLoader;
import com.github.argon4w.acceleratedrendering.core.programs.culling.ICullingProgramDispatcher;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_293;
import net.minecraft.class_2960;

public class OrientationCullingProgramDispatcher implements ICullingProgramDispatcher {

	private static  final int				GROUP_SIZE 			= 128;
	private static	final int				DISPATCH_COUNT_Y_Z	= 1;

	private			final class_293.class_5596	mode;
	private			final ComputeProgram	program;
	private			final Uniform			viewMatrixUniform;
	private			final Uniform			projectMatrixUniform;
	private			final Uniform			polygonCountUniform;
	private			final Uniform			vertexOffsetUniform;
	private			final Uniform			varyingOffsetUniform;

	public OrientationCullingProgramDispatcher(class_293.class_5596 mode, class_2960 key) {
		this.mode					= mode;
		this.program				= ComputeShaderProgramLoader.getProgram(key);
		this.viewMatrixUniform		= this.program				.getUniform("viewMatrix");
		this.projectMatrixUniform	= this.program				.getUniform("projectMatrix");
		this.polygonCountUniform	= this.program				.getUniform("polygonCount");
		this.vertexOffsetUniform	= this.program				.getUniform("vertexOffset");
		this.varyingOffsetUniform	= this.program				.getUniform("varyingOffset");
	}

	@Override
	public int dispatch(AcceleratedBufferBuilder builder) {
		var vertexCount		= builder			.getTotalVertexCount();
		var polygonCount	= vertexCount / mode.field_27384;

		viewMatrixUniform	.uploadMatrix4f		(RenderSystem	.getModelViewMatrix	());
		projectMatrixUniform.uploadMatrix4f		(RenderSystem	.getProjectionMatrix());
		polygonCountUniform	.uploadUnsignedInt	(polygonCount);
		vertexOffsetUniform	.uploadUnsignedInt	((int) (builder	.getVertexBuffer	().getOffset() / builder.getVertexSize	()));
		varyingOffsetUniform.uploadUnsignedInt	((int) (builder	.getVaryingBuffer	().getOffset() / builder.getVaryingSize	()));

		program.useProgram	();
		program.dispatch	(
				(polygonCount + GROUP_SIZE - 1) / GROUP_SIZE,
				DISPATCH_COUNT_Y_Z,
				DISPATCH_COUNT_Y_Z
		);

		return program.getBarrierFlags();
	}

	@Override
	public boolean shouldCull() {
		return OrientationCullingFeature.shouldCull();
	}
}
