package com.github.argon4w.acceleratedrendering.features.entities;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.VertexConsumerExtension;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.renderers.IAcceleratedRenderer;
import lombok.experimental.ExtensionMethod;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2791;
import net.minecraft.class_4538;
import net.minecraft.class_4588;
import net.minecraft.class_5253;
import net.minecraft.class_765;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector3f;

@ExtensionMethod(VertexConsumerExtension.class)
public class AcceleratedEntityShadowRenderer implements IAcceleratedRenderer<AcceleratedEntityShadowRenderer.Context> {

	@Override
	public void render(
			class_4588	vertexConsumer,
			Context			context,
			Matrix4f		transform,
			Matrix3f		normal,
			int				light,
			int				overlay,
			int				color
	) {
		var extension	= vertexConsumer	.getAccelerated	();
		var levelReader	= context			.levelReader	();
		var chunkAccess	= context			.chunkAccess	();
		var blockPos	= context			.blockPos		();
		var center		= context			.center			();
		var size		= context			.size			();
		var weight		= context			.weight			();

		var belowPos	= context.blockPos().method_10074			();
		var blockState	= chunkAccess		.method_8320	(belowPos);

		if (blockState.method_26217() == class_2464.field_11455) {
			return;
		}

		var levelBrightness = levelReader.method_22339(blockPos);

		if (levelBrightness <= 3) {
			return;
		}

		if (!blockState.method_26234(chunkAccess, belowPos)) {
			return;
		}

		var voxelShape = blockState.method_26218(chunkAccess, belowPos);

		if (voxelShape.method_1110()) {
			return;
		}

		var dimensionBrightness	= class_765.method_23284(levelReader.method_8597(), levelBrightness);
		var shadowTransparency	= weight * 0.5f * dimensionBrightness * 255.0f;

		if (shadowTransparency < 0.0f) {
			return;
		}

		if (shadowTransparency > 255.0f) {
			shadowTransparency = 255.0f;
		}

		var shadowColor	= class_5253.class_5254	.method_58144	((int) shadowTransparency, color);
		var bounds		= voxelShape		.method_1107	();

		var minX = blockPos.method_10263() + (float) bounds.field_1323;
		var maxX = blockPos.method_10263() + (float) bounds.field_1320;
		var minY = blockPos.method_10264() + (float) bounds.field_1322;
		var minZ = blockPos.method_10260() + (float) bounds.field_1321;
		var maxZ = blockPos.method_10260() + (float) bounds.field_1324;

		var minPosX = minX - center.x;
		var maxPosX = maxX - center.x;
		var minPosY = minY - center.y;
		var minPosZ = minZ - center.z;
		var maxPosZ = maxZ - center.z;

		var u0 = -minPosX / 2.0f / size + 0.5f;
		var u1 = -maxPosX / 2.0f / size + 0.5f;
		var v0 = -minPosZ / 2.0f / size + 0.5f;
		var v1 = -maxPosZ / 2.0f / size + 0.5f;

		extension.beginTransform(transform, normal);

		var positions = new Vector3f[] {
				new Vector3f(minPosX, minPosY, minPosZ),
				new Vector3f(minPosX, minPosY, maxPosZ),
				new Vector3f(maxPosX, minPosY, maxPosZ),
				new Vector3f(maxPosX, minPosY, minPosZ),
		};

		var texCoords = new Vector2f[] {
				new Vector2f(u0, v0),
				new Vector2f(u0, v1),
				new Vector2f(u1, v1),
				new Vector2f(u1, v0),
		};

		for (var i = 0; i < 4; i ++) {
			var position = positions[i];
			var texCoord = texCoords[i];

			vertexConsumer.method_23919(
					position.x,
					position.y,
					position.z,
					shadowColor,
					texCoord.x,
					texCoord.y,
					overlay,
					light,
					0.0f,
					1.0f,
					0.0f
			);
		}

		extension.endTransform();
	}

	public record Context(
			class_4538	levelReader,
			class_2791	chunkAccess,
			class_2338	blockPos,
			Vector3f	center,
			float		size,
			float		weight
	) {

	}
}
