package com.github.argon4w.acceleratedrendering.features.entities.mixins;

import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.VertexConsumerExtension;
import com.github.argon4w.acceleratedrendering.features.entities.AcceleratedEntityRenderingFeature;
import com.github.argon4w.acceleratedrendering.features.entities.AcceleratedEntityShadowRenderer;
import lombok.experimental.ExtensionMethod;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_4538;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_765;
import net.minecraft.class_898;
import org.joml.Matrix3f;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@ExtensionMethod(VertexConsumerExtension.class)
@Mixin			(
		value		= class_898.class,
		priority	= 999
)
public class EntityRenderDispatcherMixin {

	@Unique private static final Matrix3f							SHADOW_NORMAL_MATRIX	= new Matrix3f().identity				();
	@Unique private static final AcceleratedEntityShadowRenderer	SHADOW_RENDERER			= new AcceleratedEntityShadowRenderer	();

	@Inject(
			method		= "renderBlockShadow",
			at			= @At("HEAD"),
			cancellable	= true
	)
	private static void fastBlockShadow(
			class_4587.class_4665	pPose,
			class_4588	pVertexConsumer,
			class_2791		pChunk,
			class_4538		pLevel,
			class_2338		pPos,
			double			pX,
			double			pY,
			double			pZ,
			float			pSize,
			float			pWeight,
			CallbackInfo	ci
	) {
		var extension = pVertexConsumer.getAccelerated();

		if (		CoreFeature							.isRenderingLevel				()
				&&	AcceleratedEntityRenderingFeature	.isEnabled						()
				&&	AcceleratedEntityRenderingFeature	.shouldUseAcceleratedPipeline	()
				&&	extension							.isAccelerated					()
		) {
			ci			.cancel		();
			extension	.doRender	(
					SHADOW_RENDERER,
					new AcceleratedEntityShadowRenderer.Context(
							pLevel,
							pChunk,
							pPos,
							new Vector3f(
									(float) pX,
									(float) pY,
									(float) pZ
							),
							pSize,
							pWeight
					),
					pPose.method_23761(),
					SHADOW_NORMAL_MATRIX,
					class_765	.field_32767,
					class_4608	.field_21444,
					-1
			);
		}
	}
}
