package com.github.argon4w.acceleratedrendering.features.geckolib.mixins;

import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.VertexConsumerExtension;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.renderers.IAcceleratedRenderer;
import com.github.argon4w.acceleratedrendering.features.entities.AcceleratedEntityRenderingFeature;
import lombok.experimental.ExtensionMethod;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.GeoRenderer;

@Pseudo
@ExtensionMethod(VertexConsumerExtension.class)
@Mixin			(GeoRenderer			.class)
public interface GeoRendererMixin {

	@SuppressWarnings("unchecked")
	@Inject(
			method		= "renderCubesOfBone",
			cancellable	= true,
			at			= @At(
					value	= "INVOKE",
					target	= "Lsoftware/bernie/geckolib/cache/object/GeoBone;getCubes()Ljava/util/List;",
					shift	= At.Shift.BEFORE
			)
	)
	default void renderCubesOfBoneFast(
			class_4587		poseStack,
			GeoBone			bone,
			class_4588	buffer,
			int				packedLight,
			int				packedOverlay,
			int				colour,
			CallbackInfo	ci
	) {
		var extension = buffer.getAccelerated();

		if (			AcceleratedEntityRenderingFeature	.isEnabled						()
				&&		AcceleratedEntityRenderingFeature	.shouldUseAcceleratedPipeline	()
				&&	(	CoreFeature							.isRenderingLevel				()
				||	(	CoreFeature							.isRenderingGui					()
				&&		AcceleratedEntityRenderingFeature	.shouldAccelerateInGui			()))
				&&		extension							.isAccelerated					()
		) {
			var pose = poseStack.method_23760();

			ci			.cancel		();
			extension	.doRender	(
					(IAcceleratedRenderer<Void>) bone,
					null,
					pose.method_23761	(),
					pose.method_23762	(),
					packedLight,
					packedOverlay,
					colour
			);
		}
	}
}
